package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchRestartRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchRestartResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 重启批量.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchRestartHandler extends AbstractOctopusBatchHandler<OctopusBatchRestartRequest, OctopusBatchRestartResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchRestartResponse handle(OctopusBatchRestartRequest request) throws OctopusBatchException {
		
		log.debug("Octopus Batch Restart, operator:{}, jobExecutionId:{}", request.getOperator(), request.getJobExecutionId());
		
		//批量请求参数校验
		if (request.getJobExecutionId() == null) {
			throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId不能为空");
		}
		
		//组装响应
		OctopusBatchRestartResponse response = request.createResponse();
		
		Long jobExecutionId = this.octopusBatchService.restart(request.getOperator(), request.getSystemId(), request.getJobExecutionId());
		
		response.setJobExecutionId(jobExecutionId);
		
		return response;
	}

}
