package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchRestartByJobNameRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchRestartByJobNameResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * 根据批量任务名重启最近一次失败批量.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchRestartByJobNameHandler extends AbstractOctopusBatchHandler<OctopusBatchRestartByJobNameRequest, OctopusBatchRestartByJobNameResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchRestartByJobNameResponse handle(OctopusBatchRestartByJobNameRequest request) throws OctopusBatchException {
		
		log.debug("Octopus Batch Restart By JobName, operator:{}, jobName:{}", request.getOperator(), request.getJobName());
		
		//请求校验
		if (!StringUtils.hasLength(request.getJobName())) {
			throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobName不能为空");
		}
		//组装响应
		OctopusBatchRestartByJobNameResponse response = request.createResponse();
		
		Long jobExecutionId = this.octopusBatchService.restartByJobName(request.getOperator(), request.getSystemId(), request.getJobName());
		
		response.setJobExecutionId(jobExecutionId);
		
		return response;
	}

}
