package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecution;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchAbandonRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchAbandonResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 废弃批量.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchAbandonHandler extends AbstractOctopusBatchHandler<OctopusBatchAbandonRequest, OctopusBatchAbandonResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchAbandonResponse handle(OctopusBatchAbandonRequest request) throws OctopusBatchException {
		
		log.debug("Octopus Batch Abandon, operator:{}, jobExecutionId:{}", request.getOperator(), request.getJobExecutionId());
		
		//请求校验
		if (request.getJobExecutionId() == null) {
			throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId不能为空");
		}
		
		//组装响应
		OctopusBatchAbandonResponse response = request.createResponse();
		
		//启动批量
		OctopusBatchJobExecution jobExecution = this.octopusBatchService.abandon(request.getOperator(), request.getSystemId(), request.getJobExecutionId());
		
		response.setJobExecution(jobExecution);
		
		return response;
	}

}
