package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate;

import org.krproject.ocean.skeletons.octopus.batch.api.constants.OctopusSkeletonBatchApiConstants;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchOperateRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchOperateResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchActivator;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusSkeletonBatchBadRequestException;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.ClassUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * 批量操作服务端点.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@MessageEndpoint
public class OctopusBatchOperatorActivator extends AbstractOctopusBatchActivator<OctopusBatchOperateRequest<OctopusBatchOperateResponse>, OctopusBatchOperateResponse> {
	
	@ServiceActivator(inputChannel = OctopusSkeletonBatchApiConstants.OPERATE_CHANNEL_NAME)
	public OctopusBatchOperateResponse activate(OctopusBatchOperateRequest<OctopusBatchOperateResponse> request) {
		log.info("activate OctopusBatchOperateRequest, requestName:{}, systemId:{}, jobName:{}, jobExecutionId:{}",
				ClassUtils.getUserClass(request).getName(), request.getSystemId(), 
				request.getJobName(), request.getJobExecutionId());
		log.debug("activate OctopusBatchOperateRequest:{}", request);
		OctopusBatchOperateResponse response = null;
		try {
			response = doActivate(request);
		} catch (OctopusSkeletonBatchBadRequestException e) {
			response = request.createResponse();
			response.setRespCode(BatchRespCodeEnum.BAD_REQUEST.getRespCode());
			response.setRespDesc(e.getLocalizedMessage());
		}
		log.debug("activate OctopusBatchOperateResponse:{}", response);
		log.info("activate OctopusBatchOperateResponse, responseName:{}, respCode:{}, respDesc:{}",
				ClassUtils.getUserClass(response).getName(), response.getRespCode(), response.getRespDesc());
		return response;
	}

	
	@Override
	public OctopusBatchOperateResponse responseWithException(
			OctopusBatchOperateRequest<OctopusBatchOperateResponse> request, Exception exception) {
		OctopusBatchOperateResponse response = request.createResponse();
		if (exception instanceof OctopusBatchException) {
			response.setRespCode(((OctopusBatchException) exception).getRespCode());
			response.setRespDesc(((OctopusBatchException) exception).getRespDesc());
		} else {
			response.setRespCode(BatchRespCodeEnum.SYSTEM_ERROR.getRespCode());
			response.setRespDesc(exception.getLocalizedMessage());
		}
		return response;
	}
	

	@Override
	public Object insertJournal(OctopusBatchOperateRequest<OctopusBatchOperateResponse> request) {
		return null;
	}
	

	@Override
	public void updateJournal(Object journal,
			AbstractOctopusBatchHandler<OctopusBatchOperateRequest<OctopusBatchOperateResponse>, OctopusBatchOperateResponse> handler,
			OctopusBatchOperateResponse response) {
	}

}
