package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore.handler;

import java.util.List;

import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobInfosRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobInfosResponse;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobInfo;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取所有Job信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchGetJobInfosHandler extends AbstractOctopusBatchHandler<OctopusBatchGetJobInfosRequest, OctopusBatchGetJobInfosResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchGetJobInfosResponse handle(OctopusBatchGetJobInfosRequest request) throws OctopusBatchException {

		log.debug("OctopusBatchGetJobInfosRequest:{}", request);

		OctopusBatchGetJobInfosResponse response = request.createResponse();
		
		List<OctopusBatchJobInfo> jobInfos = this.octopusBatchService.getJobInfos();
		
		response.setJobInfos(jobInfos);
		
		return response;
	}

}
