package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobExecutionsByJobNameRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobExecutionsByJobNameResponse;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecutions;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 根据JobName获取所有执行信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchGetJobExecutionsByJobNameHandler extends AbstractOctopusBatchHandler<OctopusBatchGetJobExecutionsByJobNameRequest, OctopusBatchGetJobExecutionsByJobNameResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchGetJobExecutionsByJobNameResponse handle(OctopusBatchGetJobExecutionsByJobNameRequest request) throws OctopusBatchException {
		
		log.debug("OctopusBatchGetJobExecutionsByJobNameRequest:{}", request);
		
		OctopusBatchGetJobExecutionsByJobNameResponse response = request.createResponse();
		
		OctopusBatchJobExecutions octopusBatchJobExecutions = this.octopusBatchService.getJobExecutionsByJobName(request.getSystemId(), 
				request.getJobName(), request.getJobStart(), request.getJobCount());
		
		response.setJobTotalSize(octopusBatchJobExecutions.getJobTotalSize());
		response.setJobExecutions(octopusBatchJobExecutions.getJobExecutions());
		
		return response;
	}

}
