package org.krproject.ocean.skeletons.octopus.batch.endpoint.explore.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobExecutionRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.explore.OctopusBatchGetJobExecutionResponse;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecution;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 获取Job执行信息.
 * 
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchGetJobExecutionHandler extends AbstractOctopusBatchHandler<OctopusBatchGetJobExecutionRequest, OctopusBatchGetJobExecutionResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchGetJobExecutionResponse handle(OctopusBatchGetJobExecutionRequest request) throws OctopusBatchException {
		
		log.debug("OctopusBatchGetJobExecutionRequest:{}", request);
		
		OctopusBatchGetJobExecutionResponse response = request.createResponse();
		
		OctopusBatchJobExecution jobExecution = this.octopusBatchService.getJobExecution(request.getSystemId(), request.getExecutionId());
		
		response.setJobExecution(jobExecution);
		
		return response;
	}

}
