/*
 * Decompiled with CFR 0.152.
 */
package org.kodekuality.deep.spy;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hamcrest.Matcher;
import org.kodekuality.deep.spy.answer.PredefinedBehaviourAnswer;
import org.kodekuality.deep.spy.behaviour.BehaviourActionBuilder;
import org.kodekuality.deep.spy.behaviour.SpyBehaviour;
import org.kodekuality.deep.spy.nested.ApplySpyOnNestedCall;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DeepSpy {
    private static final MockUtil MOCK_UTIL = new MockUtil();
    private static final List<SpyBehaviour> registeredBehaviours = new CopyOnWriteArrayList<SpyBehaviour>();

    public static <T> BehaviourActionBuilder<T> on(Matcher<InvocationOnMock> predicate) {
        return new BehaviourActionBuilder(predicate);
    }

    public static void on(SpyBehaviour spyBehaviour) {
        registeredBehaviours.add(spyBehaviour);
    }

    public static <T> T spy(T service) {
        if (service == null) {
            return null;
        }
        if (MOCK_UTIL.isMock(service)) {
            return service;
        }
        if (MOCK_UTIL.isSpy(service)) {
            return service;
        }
        return (T)Mockito.mock(service.getClass(), (MockSettings)Mockito.withSettings().spiedInstance(service).defaultAnswer((Answer)new PredefinedBehaviourAnswer(registeredBehaviours, new ApplySpyOnNestedCall())));
    }

    public static void clear() {
        registeredBehaviours.clear();
    }
}

