package org.kodekuality.deep.spy.matcher;

import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

import java.lang.reflect.Method;

public class MethodMatcher extends MatcherBuilder<Method, MethodMatcher> {

    public static MethodMatcher method() {
        return new MethodMatcher();
    }

    public MethodMatcher withName(Matcher<String> matcher) {
        return with(new FeatureMatcher<Method, String>(matcher, "name", "name") {
            @Override
            protected String featureValueOf(Method actual) {
                return actual.getName();
            }
        });
    }
}
