package org.kodekuality.deep.spy.matcher;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

import java.util.ArrayList;
import java.util.List;

public abstract class MatcherBuilder<T, M extends MatcherBuilder> extends BaseMatcher<T> {
    private final List<Matcher<? super T>> matchers = new ArrayList<>();

    public M with (Matcher<? super T> matcher) {
        matchers.add(matcher);
        return (M) this;
    }

    @Override
    public boolean matches(Object item) {
        return AllOf.allOf(matchers).matches(item);
    }

    @Override
    public void describeTo(Description description) {
        description.appendDescriptionOf(AllOf.allOf(matchers));
    }
}
