package org.kodekuality.deep.spy.matcher;

import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.mockito.invocation.InvocationOnMock;

import java.lang.reflect.Method;
import java.util.Arrays;

public class InvocationOnMockMatcher extends MatcherBuilder<InvocationOnMock, InvocationOnMockMatcher> {
    public static InvocationOnMockMatcher invocation() {
        return new InvocationOnMockMatcher();
    }

    public InvocationOnMockMatcher over(Matcher<Object> mockMatcher) {
        return with(new FeatureMatcher<InvocationOnMock, Object>(mockMatcher, "mock", "mock") {
            @Override
            protected Object featureValueOf(InvocationOnMock actual) {
                return actual.getMock();
            }
        });
    }
    public InvocationOnMockMatcher ofMethod(Matcher<Method> methodMatcher) {
        return with(new FeatureMatcher<InvocationOnMock, Method>(methodMatcher, "method", "method") {
            @Override
            protected Method featureValueOf(InvocationOnMock actual) {
                return actual.getMethod();
            }
        });
    }

    public <T> InvocationOnMockMatcher  withArguments (Matcher<Iterable<? super T>> argumentsMatcher) {
        return with(new FeatureMatcher<InvocationOnMock, Iterable<? super T>>(argumentsMatcher, "arguments", "arguments") {
            @Override
            protected Iterable<? super T> featureValueOf(InvocationOnMock actual) {
                return Arrays.asList(actual.getArguments());
            }
        });
    }
}
