/*
 * Decompiled with CFR 0.152.
 */
package org.kodekuality.deep.spy.behaviour;

import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.kodekuality.deep.spy.DeepSpy;
import org.kodekuality.deep.spy.behaviour.BehaviourAction;
import org.kodekuality.deep.spy.behaviour.SpyBehaviour;
import org.kodekuality.deep.spy.behaviour.Transform;
import org.mockito.invocation.InvocationOnMock;

public class BehaviourActionBuilder<T> {
    private final Matcher<InvocationOnMock> predicate;

    public BehaviourActionBuilder(Matcher<InvocationOnMock> predicate) {
        this.predicate = predicate;
    }

    public void throwException(final Supplier<Throwable> exception) {
        DeepSpy.on(new SpyBehaviour(this.predicate, new BehaviourAction(){

            @Override
            public Object execute(InvocationOnMock invocationOnMock) throws Throwable {
                throw (Throwable)exception.get();
            }
        }));
    }

    public void returnValue(final T value) {
        DeepSpy.on(new SpyBehaviour(this.predicate, new BehaviourAction(){

            @Override
            public Object execute(InvocationOnMock invocationOnMock) throws Throwable {
                return value;
            }
        }));
    }

    public void transform(final Transform<T> transform) {
        DeepSpy.on(new SpyBehaviour(this.predicate, new BehaviourAction(){

            @Override
            public Object execute(InvocationOnMock invocationOnMock) throws Throwable {
                return transform.transform(invocationOnMock.callRealMethod());
            }
        }));
    }
}

