/*
 * Decompiled with CFR 0.152.
 */
package org.kodekuality.deep.spy.answer;

import java.util.List;
import java.util.function.Function;
import org.kodekuality.deep.spy.behaviour.SpyBehaviour;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PredefinedBehaviourAnswer
implements Answer<Object> {
    private final List<SpyBehaviour> registeredBehaviours;
    private final Function<Object, Object> realMethodResultWrapper;

    public PredefinedBehaviourAnswer(List<SpyBehaviour> registeredBehaviours, Function<Object, Object> realMethodResultWrapper) {
        this.registeredBehaviours = registeredBehaviours;
        this.realMethodResultWrapper = realMethodResultWrapper;
    }

    public Object answer(InvocationOnMock invocation) throws Throwable {
        for (SpyBehaviour registeredBehaviour : this.registeredBehaviours) {
            if (!registeredBehaviour.getMatcher().matches((Object)invocation)) continue;
            return registeredBehaviour.getAction().execute(invocation);
        }
        return this.realMethodResultWrapper.apply(invocation.callRealMethod());
    }
}

