package org.kodekuality.deep.spy.nested;

import org.kodekuality.deep.spy.DeepSpy;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.function.Function;

public class ApplySpyOnNestedCall implements Function<Object, Object> {
    private static final MockUtil MOCK_UTIL = new MockUtil();

    @Override
    public Object apply(Object input) {
        if (input == null) return null;
        if (MOCK_UTIL.isMock(input)) return input;
        if (MOCK_UTIL.isSpy(input)) return input;
        if (Modifier.isFinal(input.getClass().getModifiers())) {
            return input;
        }
        if (Proxy.isProxyClass(input.getClass())) {
            return input;
        }
        try {
            return DeepSpy.spy(input);
        } catch (IllegalAccessError e) {
            return input;
        }
    }
}
