package org.kodekuality.deep.spy.answer;

import org.kodekuality.deep.spy.behaviour.SpyBehaviour;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

import java.util.List;
import java.util.function.Function;

public class PredefinedBehaviourAnswer implements Answer<Object> {
    private final List<SpyBehaviour> registeredBehaviours;
    private final Function<Object, Object> realMethodResultWrapper;

    public PredefinedBehaviourAnswer(List<SpyBehaviour> registeredBehaviours, Function<Object, Object> realMethodResultWrapper) {
        this.registeredBehaviours = registeredBehaviours;
        this.realMethodResultWrapper = realMethodResultWrapper;
    }

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        for (SpyBehaviour registeredBehaviour : registeredBehaviours) {
            if (registeredBehaviour.getMatcher().matches(invocation)) {
                return registeredBehaviour.getAction().execute(invocation);
            }
        }

        return realMethodResultWrapper.apply(invocation.callRealMethod());
    }
}
