package org.kodekuality.deep.spy;

import org.hamcrest.Matcher;
import org.kodekuality.deep.spy.nested.ApplySpyOnNestedCall;
import org.kodekuality.deep.spy.answer.PredefinedBehaviourAnswer;
import org.kodekuality.deep.spy.behaviour.BehaviourActionBuilder;
import org.kodekuality.deep.spy.behaviour.SpyBehaviour;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.InvocationOnMock;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import static org.mockito.Mockito.withSettings;

public class DeepSpy {
    private static final MockUtil MOCK_UTIL = new MockUtil();

    private static final List<SpyBehaviour> registeredBehaviours = new CopyOnWriteArrayList<>();

    public static <T> BehaviourActionBuilder<T> on (Matcher<InvocationOnMock> predicate) {
        return new BehaviourActionBuilder<>(predicate);
    }

    public static void on(SpyBehaviour spyBehaviour) {
        registeredBehaviours.add(spyBehaviour);
    }

    public static <T> T spy(T service) {
        if (service == null) return null;
        if (MOCK_UTIL.isMock(service)) return service;
        if (MOCK_UTIL.isSpy(service)) return service;
        return Mockito.mock((Class<T>) service.getClass(), withSettings()
                .spiedInstance(service)
                .defaultAnswer(new PredefinedBehaviourAnswer(registeredBehaviours, new ApplySpyOnNestedCall())));
    }

    public static void clear() {
        registeredBehaviours.clear();
    }
}
