package org.kodekuality.deep.spy.behaviour;

import org.hamcrest.Matcher;
import org.mockito.invocation.InvocationOnMock;

public class SpyBehaviour {
    private final Matcher<InvocationOnMock> predicate;
    private final BehaviourAction action;

    public SpyBehaviour(Matcher<InvocationOnMock> predicate, BehaviourAction action) {
        this.predicate = predicate;
        this.action = action;
    }

    public Matcher<InvocationOnMock> getMatcher() {
        return predicate;
    }

    public BehaviourAction getAction() {
        return action;
    }
}
