package org.kodekuality.deep.spy.behaviour;

import org.hamcrest.Matcher;
import org.kodekuality.deep.spy.DeepSpy;
import org.mockito.invocation.InvocationOnMock;

public class BehaviourActionBuilder<T> {
    private final Matcher<InvocationOnMock> predicate;

    public BehaviourActionBuilder(Matcher<InvocationOnMock> predicate) {
        this.predicate = predicate;
    }

    public void throwException (Throwable e) {
        DeepSpy.on(new SpyBehaviour(
                predicate,
                new BehaviourAction() {
                    @Override
                    public Object execute(InvocationOnMock invocationOnMock) throws Throwable {
                        throw e;
                    }
                }
        ));
    }

    public void returnValue (T value) {
        DeepSpy.on(new SpyBehaviour(
                predicate,
                new BehaviourAction() {
                    @Override
                    public Object execute(InvocationOnMock invocationOnMock) throws Throwable {
                        return value;
                    }
                }
        ));
    }

    public void transform(Transform<T> transform) {
        DeepSpy.on(new SpyBehaviour(
                predicate,
                new BehaviourAction() {
                    @Override
                    public Object execute(InvocationOnMock invocationOnMock) throws Throwable {
                        return transform.transform((T) invocationOnMock.callRealMethod());
                    }
                }
        ));
    }
}
