/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.transport.channel;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jupiter.common.util.Maps;
import org.jupiter.transport.Directory;
import org.jupiter.transport.channel.CopyOnWriteGroupList;
import org.jupiter.transport.channel.JChannelGroup;

public class DirectoryJChannelGroup {
    private final ConcurrentMap<String, CopyOnWriteGroupList> groups = Maps.newConcurrentMap();
    private final GroupRefCounterMap groupRefCounter = new GroupRefCounterMap();

    public CopyOnWriteGroupList find(Directory directory) {
        CopyOnWriteGroupList newGroupList;
        String _directory = directory.directoryString();
        CopyOnWriteGroupList groupList = (CopyOnWriteGroupList)this.groups.get(_directory);
        if (groupList == null && (groupList = this.groups.putIfAbsent(_directory, newGroupList = new CopyOnWriteGroupList(this))) == null) {
            groupList = newGroupList;
        }
        return groupList;
    }

    public int getRefCount(JChannelGroup group) {
        AtomicInteger counter = (AtomicInteger)this.groupRefCounter.get(group);
        if (counter == null) {
            return 0;
        }
        return counter.get();
    }

    public int incrementRefCount(JChannelGroup group) {
        return this.groupRefCounter.getOrCreate(group).incrementAndGet();
    }

    public int decrementRefCount(JChannelGroup group) {
        AtomicInteger counter = (AtomicInteger)this.groupRefCounter.get(group);
        if (counter == null) {
            return 0;
        }
        int count = counter.decrementAndGet();
        if (count == 0) {
            this.groupRefCounter.remove(group);
        }
        return count;
    }

    static class GroupRefCounterMap
    extends ConcurrentHashMap<JChannelGroup, AtomicInteger> {
        private static final long serialVersionUID = 6590976614405397299L;

        GroupRefCounterMap() {
        }

        public AtomicInteger getOrCreate(JChannelGroup key) {
            AtomicInteger newCounter;
            AtomicInteger counter = (AtomicInteger)super.get(key);
            if (counter == null && (counter = super.putIfAbsent(key, newCounter = new AtomicInteger(0))) == null) {
                counter = newCounter;
            }
            return counter;
        }
    }
}

