/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.transport.channel;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jupiter.common.util.internal.UnsafeUtil;
import org.jupiter.transport.channel.DirectoryJChannelGroup;
import org.jupiter.transport.channel.JChannelGroup;

public class CopyOnWriteGroupList {
    private static final JChannelGroup[] EMPTY_GROUP = new JChannelGroup[0];
    private static final Object[] EMPTY_ARRAY = new Object[]{EMPTY_GROUP, null};
    private final transient ReentrantLock lock = new ReentrantLock();
    private final DirectoryJChannelGroup parent;
    private volatile transient Object[] array;

    public CopyOnWriteGroupList(DirectoryJChannelGroup parent) {
        this.parent = parent;
        this.setArray(EMPTY_ARRAY);
    }

    public final JChannelGroup[] getSnapshot() {
        return CopyOnWriteGroupList.tabAt0(this.array);
    }

    public final Object getWeightArray(JChannelGroup[] snapshot, String directory) {
        Object[] array = this.array;
        return CopyOnWriteGroupList.tabAt0(array) != snapshot ? null : (CopyOnWriteGroupList.tabAt1(array) == null ? null : CopyOnWriteGroupList.tabAt1(array).get(directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setWeightArray(JChannelGroup[] snapshot, String directory, Object weightArray) {
        if (weightArray == null || snapshot != CopyOnWriteGroupList.tabAt0(this.array)) {
            return false;
        }
        ReentrantLock lock = this.lock;
        boolean locked = lock.tryLock();
        if (locked) {
            try {
                if (snapshot != CopyOnWriteGroupList.tabAt0(this.array)) {
                    boolean bl = false;
                    return bl;
                }
                this.setWeightArray(directory, weightArray);
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    private void setArray(Object[] array) {
        this.array = array;
    }

    private void setArray(JChannelGroup[] groups, Object weightArray) {
        this.array = new Object[]{groups, weightArray};
    }

    private void setWeightArray(String directory, Object weightArray) {
        Map<String, Object> weightsMap = CopyOnWriteGroupList.tabAt1(this.array);
        if (weightsMap == null) {
            weightsMap = new HashMap<String, Object>();
            CopyOnWriteGroupList.setTabAt(this.array, 1, weightsMap);
        }
        weightsMap.put(directory, weightArray);
    }

    public int size() {
        return CopyOnWriteGroupList.tabAt0(this.array).length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(JChannelGroup o) {
        JChannelGroup[] elements = CopyOnWriteGroupList.tabAt0(this.array);
        return this.indexOf(o, elements, 0, elements.length) >= 0;
    }

    public int indexOf(JChannelGroup o) {
        JChannelGroup[] elements = CopyOnWriteGroupList.tabAt0(this.array);
        return this.indexOf(o, elements, 0, elements.length);
    }

    public int indexOf(JChannelGroup o, int index) {
        JChannelGroup[] elements = CopyOnWriteGroupList.tabAt0(this.array);
        return this.indexOf(o, elements, index, elements.length);
    }

    public JChannelGroup[] toArray() {
        JChannelGroup[] elements = CopyOnWriteGroupList.tabAt0(this.array);
        return Arrays.copyOf(elements, elements.length);
    }

    private JChannelGroup get(JChannelGroup[] array, int index) {
        return array[index];
    }

    public JChannelGroup get(int index) {
        return this.get(CopyOnWriteGroupList.tabAt0(this.array), index);
    }

    public boolean remove(JChannelGroup o) {
        JChannelGroup[] snapshot = CopyOnWriteGroupList.tabAt0(this.array);
        int index = this.indexOf(o, snapshot, 0, snapshot.length);
        return index >= 0 && this.remove(o, snapshot, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(JChannelGroup o, JChannelGroup[] snapshot, int index) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl;
            int len;
            JChannelGroup[] current;
            block9: {
                current = CopyOnWriteGroupList.tabAt0(this.array);
                len = current.length;
                if (snapshot != current) {
                    int prefix = Math.min(index, len);
                    for (int i = 0; i < prefix; ++i) {
                        if (current[i] == snapshot[i] || !this.eq(o, current[i])) continue;
                        index = i;
                        break block9;
                    }
                    if (index >= len) {
                        bl = false;
                        return bl;
                    }
                    if (current[index] != o && (index = this.indexOf(o, current, index, len)) < 0) {
                        bl = false;
                        return bl;
                    }
                }
            }
            JChannelGroup[] newElements = new JChannelGroup[len - 1];
            System.arraycopy(current, 0, newElements, 0, index);
            System.arraycopy(current, index + 1, newElements, index, len - index - 1);
            this.setArray(newElements, null);
            this.parent.decrementRefCount(o);
            bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean addIfAbsent(JChannelGroup o) {
        JChannelGroup[] snapshot = CopyOnWriteGroupList.tabAt0(this.array);
        return this.indexOf(o, snapshot, 0, snapshot.length) < 0 && this.addIfAbsent(o, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfAbsent(JChannelGroup o, JChannelGroup[] snapshot) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl;
            JChannelGroup[] current = CopyOnWriteGroupList.tabAt0(this.array);
            int len = current.length;
            if (snapshot != current) {
                int common = Math.min(snapshot.length, len);
                for (int i = 0; i < common; ++i) {
                    if (current[i] == snapshot[i] || !this.eq(o, current[i])) continue;
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.indexOf(o, current, common, len) >= 0) {
                    bl = false;
                    return bl;
                }
            }
            JChannelGroup[] newElements = Arrays.copyOf(current, len + 1);
            newElements[len] = o;
            this.setArray(newElements, null);
            this.parent.incrementRefCount(o);
            bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean containsAll(Collection<? extends JChannelGroup> c) {
        JChannelGroup[] elements = CopyOnWriteGroupList.tabAt0(this.array);
        int len = elements.length;
        for (JChannelGroup jChannelGroup : c) {
            if (this.indexOf(jChannelGroup, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.setArray(EMPTY_ARRAY);
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        return Arrays.toString(CopyOnWriteGroupList.tabAt0(this.array));
    }

    public boolean equals(Object o) {
        JChannelGroup[] otherElements;
        int otherLen;
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyOnWriteGroupList)) {
            return false;
        }
        CopyOnWriteGroupList other = (CopyOnWriteGroupList)o;
        JChannelGroup[] elements = CopyOnWriteGroupList.tabAt0(this.array);
        int len = elements.length;
        if (len != (otherLen = (otherElements = CopyOnWriteGroupList.tabAt0(other.array)).length)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.eq(elements[i], otherElements[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (JChannelGroup o : CopyOnWriteGroupList.tabAt0(this.array)) {
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
        }
        return hashCode;
    }

    private boolean eq(JChannelGroup o1, JChannelGroup o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private int indexOf(JChannelGroup o, JChannelGroup[] elements, int index, int fence) {
        if (o == null) {
            for (int i = index; i < fence; ++i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < fence; ++i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static JChannelGroup[] tabAt0(Object[] array) {
        return (JChannelGroup[])CopyOnWriteGroupList.tabAt(array, 0);
    }

    private static Map<String, Object> tabAt1(Object[] array) {
        return (Map)CopyOnWriteGroupList.tabAt(array, 1);
    }

    private static Object tabAt(Object[] array, int index) {
        return UnsafeUtil.getObjectVolatile((Object[])array, (long)index);
    }

    private static void setTabAt(Object[] array, int index, Object value) {
        UnsafeUtil.putObjectVolatile((Object[])array, (long)index, (Object)value);
    }
}

