/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.transport;

import org.jupiter.common.util.Requires;
import org.jupiter.transport.UnresolvedAddress;

public class UnresolvedSocketAddress
implements UnresolvedAddress {
    private final String host;
    private final int port;

    public UnresolvedSocketAddress(String host, int port) {
        Requires.requireNotNull((Object)host, (Object)"host can't be null");
        Requires.requireTrue((port > 0 && port < 65535 ? 1 : 0) != 0, (Object)("port out of range:" + port));
        this.host = host;
        this.port = port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getPath() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedSocketAddress that = (UnresolvedSocketAddress)o;
        return this.port == that.port && this.host.equals(that.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return this.host + ':' + this.port;
    }
}

