/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.transport;

public enum Status {
    OK(32, "OK"),
    CLIENT_ERROR(48, "CLIENT_ERROR"),
    CLIENT_TIMEOUT(49, "CLIENT_TIMEOUT"),
    SERVER_TIMEOUT(50, "SERVER_TIMEOUT"),
    BAD_REQUEST(64, "BAD_REQUEST"),
    SERVICE_NOT_FOUND(68, "SERVICE_NOT_FOUND"),
    SERVER_ERROR(80, "SERVER_ERROR"),
    SERVER_BUSY(81, "SERVER_BUSY"),
    SERVICE_EXPECTED_ERROR(82, "SERVICE_EXPECTED_ERROR"),
    SERVICE_UNEXPECTED_ERROR(83, "SERVICE_UNEXPECTED_ERROR"),
    APP_FLOW_CONTROL(84, "APP_FLOW_CONTROL"),
    PROVIDER_FLOW_CONTROL(85, "PROVIDER_FLOW_CONTROL"),
    DESERIALIZATION_FAIL(96, "DESERIALIZATION_FAIL");

    private byte value;
    private String description;

    private Status(byte value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Status parse(byte value) {
        for (Status s : Status.values()) {
            if (s.value != value) continue;
            return s;
        }
        return null;
    }

    public byte value() {
        return this.value;
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return this.description();
    }
}

