/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.transport;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jupiter.common.util.Maps;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.transport.JConnection;
import org.jupiter.transport.UnresolvedAddress;

public class JConnectionManager {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JConnectionManager.class);
    private final ConcurrentMap<UnresolvedAddress, CopyOnWriteArrayList<JConnection>> connections = Maps.newConcurrentMap();

    public void manage(JConnection connection) {
        CopyOnWriteArrayList newList;
        UnresolvedAddress address = connection.getAddress();
        CopyOnWriteArrayList<JConnection> list = (CopyOnWriteArrayList<JConnection>)this.connections.get(address);
        if (list == null && (list = this.connections.putIfAbsent(address, newList = new CopyOnWriteArrayList())) == null) {
            list = newList;
        }
        list.add(connection);
    }

    public void cancelAutoReconnect(UnresolvedAddress address) {
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)this.connections.remove(address);
        if (list != null) {
            for (JConnection c : list) {
                c.setReconnect(false);
            }
            logger.warn("Cancel reconnect to: {}.", (Object)address);
        }
    }

    public void cancelAllAutoReconnect() {
        for (UnresolvedAddress address : this.connections.keySet()) {
            this.cancelAutoReconnect(address);
        }
    }
}

