/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.serialization.hessian;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jupiter.common.util.ThrowUtil;
import org.jupiter.serialization.Serializer;
import org.jupiter.serialization.SerializerType;
import org.jupiter.serialization.hessian.io.Inputs;
import org.jupiter.serialization.hessian.io.Outputs;
import org.jupiter.serialization.io.InputBuf;
import org.jupiter.serialization.io.OutputBuf;
import org.jupiter.serialization.io.OutputStreams;

public class HessianSerializer
extends Serializer {
    public byte code() {
        return SerializerType.HESSIAN.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> OutputBuf writeObject(OutputBuf outputBuf, T obj) {
        Hessian2Output output = Outputs.getOutput(outputBuf);
        try {
            output.writeObject(obj);
            output.flush();
            OutputBuf outputBuf2 = outputBuf;
            return outputBuf2;
        }
        catch (IOException e) {
            ThrowUtil.throwException((Throwable)e);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> byte[] writeObject(T obj) {
        ByteArrayOutputStream buf = OutputStreams.getByteArrayOutputStream();
        Hessian2Output output = Outputs.getOutput(buf);
        try {
            output.writeObject(obj);
            output.flush();
            byte[] byArray = buf.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            ThrowUtil.throwException((Throwable)e);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
            OutputStreams.resetBuf((ByteArrayOutputStream)buf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(InputBuf inputBuf, Class<T> clazz) {
        Hessian2Input input = Inputs.getInput(inputBuf);
        try {
            Object obj = input.readObject(clazz);
            T t = clazz.cast(obj);
            return t;
        }
        catch (IOException e) {
            ThrowUtil.throwException((Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
            inputBuf.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(byte[] bytes, int offset, int length, Class<T> clazz) {
        block11: {
            T t;
            Hessian2Input input = Inputs.getInput(bytes, offset, length);
            try {
                Object obj = input.readObject(clazz);
                t = clazz.cast(obj);
            }
            catch (IOException e) {
                ThrowUtil.throwException((Throwable)e);
                break block11;
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            return t;
        }
        return null;
    }

    public String toString() {
        return "hessian:(code=" + this.code() + ")";
    }
}

