/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.testkit.engine.Event;
import org.junit.platform.testkit.engine.Events;

@API(status=API.Status.MAINTAINED, since="1.7")
public class EngineExecutionResults {
    private final Events allEvents;
    private final Events testEvents;
    private final Events containerEvents;

    EngineExecutionResults(List<Event> events) {
        Preconditions.notNull(events, (String)"Event list must not be null");
        Preconditions.containsNoNullElements(events, (String)"Event list must not contain null elements");
        this.allEvents = new Events(events, "All");
        this.testEvents = new Events(EngineExecutionResults.filterEvents(events, TestDescriptor::isTest), "Test");
        this.containerEvents = new Events(EngineExecutionResults.filterEvents(events, TestDescriptor::isContainer), "Container");
    }

    public Events allEvents() {
        return this.allEvents;
    }

    public Events containerEvents() {
        return this.containerEvents;
    }

    public Events testEvents() {
        return this.testEvents;
    }

    private static Stream<Event> filterEvents(List<Event> events, Predicate<? super TestDescriptor> predicate) {
        return events.stream().filter(Event.byTestDescriptor(predicate));
    }
}

