/*
 * Decompiled with CFR 0.152.
 */
package org.jsystemtest.jsystem_services_tests;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import jsystem.extensions.paramproviders.GenericObjectParameterProvider;
import jsystem.extensions.paramproviders.ObjectArrayParameterProvider;
import jsystem.framework.ParameterProperties;
import jsystem.framework.TestProperties;
import jsystem.framework.scenario.UseProvider;
import junit.framework.SystemTestCase4;
import org.jsystemtest.jsystem_services_tests.Account;
import org.junit.Test;

public class TestsExamples
extends SystemTestCase4 {
    private File file = new File(".");
    private String str = "Some string";
    private int i = 5;
    private Date date = new Date();
    private String[] strArr;
    private Account account;
    private Account[] accountArr;

    @Test
    @TestProperties(name="Report Success", paramsInclude={""})
    public void reportSuccess() {
        report.report("Success");
    }

    @Test
    @TestProperties(name="Report Failure", paramsInclude={""})
    public void reportFailure() {
        report.report("Failure", false);
    }

    @Test
    @TestProperties(name="Report Error", paramsInclude={""})
    public void reportError() throws Exception {
        report.report("Error");
        throw new Exception("Error");
    }

    @Test
    @TestProperties(name="Report Warning", paramsInclude={""})
    public void reportWarning() {
        report.report("Warning", 2);
    }

    @Test
    @TestProperties(name="Test with file '${file}' string '${str}' integer ${i} date ${date}", paramsInclude={"file", "str", "i", "date", "strArr"})
    public void testWithParameters() {
        report.report("File: " + this.file.getAbsolutePath());
        report.report("Date: " + this.date.toString());
        report.report("String: " + this.str);
        report.report("Integer: " + this.i);
    }

    @Test
    @TestProperties(name="Report With Levels", paramsInclude={""})
    public void reportWithLevels() throws IOException {
        report.startLevel("Starting level", 2);
        try {
            report.report("Inside level");
            report.report("Inside level");
            report.startLevel("Starting level", 2);
            try {
                report.report("Inside level");
            }
            finally {
                report.stopLevel();
            }
            report.report("Inside level");
        }
        finally {
            report.stopLevel();
        }
    }

    @Test
    @TestProperties(name="Test with parameter provider", paramsInclude={"account", "accountArr"})
    public void testWithParameterProvider() {
    }

    public File getFile() {
        return this.file;
    }

    @ParameterProperties(description="File Parameter")
    public void setFile(File file) {
        this.file = file;
    }

    public String getStr() {
        return this.str;
    }

    @ParameterProperties(description="String Parameter")
    public void setStr(String str) {
        this.str = str;
    }

    public int getI() {
        return this.i;
    }

    @ParameterProperties(description="Integer Parameter")
    public void setI(int i) {
        this.i = i;
    }

    public Date getDate() {
        return this.date;
    }

    @ParameterProperties(description="Java Date Parameter")
    public void setDate(Date date) {
        this.date = date;
    }

    public String[] getStrArr() {
        return this.strArr;
    }

    @ParameterProperties(description="String Array Parameter")
    public void setStrArr(String[] strArr) {
        this.strArr = strArr;
    }

    public Account getAccount() {
        return this.account;
    }

    @ParameterProperties(description="Provider that exposes bean")
    @UseProvider(provider=GenericObjectParameterProvider.class)
    public void setAccount(Account account) {
        this.account = account;
    }

    public Account[] getAccountArr() {
        return this.accountArr;
    }

    @ParameterProperties(description="Provider that exposes bean array")
    @UseProvider(provider=ObjectArrayParameterProvider.class)
    public void setAccountArr(Account[] accountArr) {
        this.accountArr = accountArr;
    }
}

