/*
 * Decompiled with CFR 0.152.
 */
package org.jsystem.scenario;

import java.io.File;
import jsystem.framework.scenario.JTest;
import jsystem.framework.scenario.Parameter;
import jsystem.framework.scenario.RunnerTest;
import jsystem.framework.scenario.Scenario;
import jsystem.framework.scenario.ScenariosManager;
import jsystem.framework.scenario.flow_control.AntForLoop;
import junit.framework.SystemTestCase4;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioApiUsage
extends SystemTestCase4 {
    @Test
    public void createSimpleScenario() throws Exception {
        File f = new File(ScenariosManager.getInstance().getScenariosDirectoryFiles(), "scenarios/ApiScenario.xml");
        f.delete();
        f = new File(ScenariosManager.getInstance().getScenariosDirectoryFiles(), "scenarios/ApiScenarioParent.xml");
        f.delete();
        RunnerTest t1 = new RunnerTest("com.aqua.services.multiuser.TestParametersExample", "testPing");
        RunnerTest t2 = new RunnerTest("com.aqua.services.junit4.JUnit4Example", "myTestMethod");
        Scenario s = new Scenario(ScenariosManager.getInstance().getScenariosDirectoryFiles(), "scenarios/ApiScenario");
        s.addTest((JTest)t1);
        s.addTest((JTest)t2);
        s.save();
        RunnerTest s2t1 = t1.cloneTest();
        Scenario s2 = new Scenario(ScenariosManager.getInstance().getScenariosDirectoryFiles(), "scenarios/ApiScenarioParent");
        s2.addTest((JTest)s2t1);
        s2.addTest((JTest)s);
        s2.save();
    }

    @Test
    public void loadScenario() throws Exception {
        this.createSimpleScenario();
        Scenario s = new Scenario(ScenariosManager.getInstance().getScenariosDirectoryFiles(), "scenarios/ApiScenario");
        RunnerTest test = s.getTest(0);
        Assert.assertEquals((Object)"com.aqua.services.multiuser.TestParametersExample", (Object)test.getClassName());
    }

    @Test
    public void createScenarioWithFlowControl() throws Exception {
        File f = new File(ScenariosManager.getInstance().getScenariosDirectoryFiles(), "scenarios/ApiScenarioWithFor.xml");
        f.delete();
        Scenario s = new Scenario(ScenariosManager.getInstance().getScenariosDirectoryFiles(), "scenarios/ApiScenarioWithFor");
        AntForLoop loop = new AntForLoop();
        loop.setLoopValuesList("1;2;3;4");
        RunnerTest t1 = new RunnerTest("com.aqua.services.multiuser.TestParametersExample", "testPing");
        RunnerTest t2 = new RunnerTest("com.aqua.services.junit4.JUnit4Example", "myTestMethod");
        loop.addTest((JTest)t1);
        loop.addTest((JTest)t2);
        s.addTest((JTest)loop);
        s.save();
    }

    @Test
    public void createScenarioWithTestAndParameters() throws Exception {
        File f = new File(ScenariosManager.getInstance().getScenariosDirectoryFiles(), "scenarios/ApiScenarioWithParam.xml");
        f.delete();
        Scenario s = new Scenario(ScenariosManager.getInstance().getScenariosDirectoryFiles(), "scenarios/ApiScenarioWithParam");
        RunnerTest t1 = new RunnerTest("com.aqua.services.multiuser.TestParametersExample", "testPing");
        s.addTest((JTest)t1);
        t1.load();
        t1.loadParametersAndValues();
        Parameter p = new Parameter();
        p.setName("PingDestination");
        p.setType(Parameter.ParameterType.STRING);
        p.setValue((Object)"127.0.0.1");
        Parameter p1 = new Parameter();
        p1.setName("PacketSize");
        p1.setType(Parameter.ParameterType.INT);
        p1.setValue((Object)350);
        t1.setParameters(new Parameter[]{p, p1});
        s.save();
    }
}

