/*
 * Decompiled with CFR 0.152.
 */
package com.aqua.services.reports;

import java.io.File;
import java.util.Random;
import jsystem.framework.report.Reporter;
import jsystem.framework.report.ReporterHelper;
import junit.framework.SystemTestCase;

public class TestPropertiesDemonstrationTest
extends SystemTestCase {
    public void setUp() throws Exception {
    }

    public void testAddProperty() throws Exception {
        report.addProperty("packet-loss", "0.05");
        report.addProperty("bandwidth", "30");
    }

    public void testLinkProperties() throws Exception {
        ReporterHelper.copyFileToReporterAndAddLinkProperty((Reporter)report, (File)new File("jsystem.properties"), (String)"linkToFile", (String)"jsystem properties");
        ReporterHelper.addLinkProperty((Reporter)report, (String)"jsystem.properties", (String)"linkToFileWithoutCopy", (String)"jsystem properties title");
        ReporterHelper.addLinkProperty((Reporter)report, (String)"http://www.one.co.il", (String)"linkToOneSports", (String)"one sports");
    }

    public void testBenchmarkExample() throws Exception {
        double packetLoss = this.getPacketLoss();
        int bandwidth = this.getBandwidth();
        int averageCpuUsage = this.getAverageCpuUsage();
        int peakCpuUsage = this.getPeakCpuUsage();
        int averageUploadRate = this.getAverageUploadRate();
        int averageDownloadRate = this.getAverageDownloadRate();
        report.addProperty("packet-loss", "" + packetLoss);
        report.addProperty("bandwidth", "" + bandwidth);
        report.addProperty("average-cpu-usage", "" + averageCpuUsage);
        report.addProperty("peak-cpu-usage", "" + peakCpuUsage);
        report.addProperty("average-upload-rate", "" + averageUploadRate);
        report.addProperty("average-download-rate", "" + averageDownloadRate);
        ReporterHelper.copyFileToReporterAndAddLinkProperty((Reporter)report, (File)new File("jsystem.properties"), (String)"Log", (String)"Link to Log");
    }

    private double getPacketLoss() {
        return (double)new Random().nextInt(10) + new Random().nextDouble() * 10.0;
    }

    private int getBandwidth() {
        return new Random().nextInt(100);
    }

    private int getAverageCpuUsage() {
        return new Random().nextInt(100);
    }

    private int getPeakCpuUsage() {
        return new Random().nextInt(100);
    }

    private int getAverageUploadRate() {
        return new Random().nextInt(100);
    }

    private int getAverageDownloadRate() {
        return new Random().nextInt(100);
    }
}

