/*
 * Decompiled with CFR 0.152.
 */
package com.aqua.services.reporter;

import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Properties;
import java.util.Random;
import javax.imageio.ImageIO;
import jsystem.extensions.reporter.HtmlReporterUtils;
import jsystem.framework.TestProperties;
import jsystem.framework.graph.Graph;
import jsystem.framework.graph.GraphMonitorManager;
import jsystem.framework.report.Reporter;
import jsystem.framework.report.ReporterHelper;
import junit.framework.SystemTestCase4;
import org.apache.commons.io.FileUtils;
import org.junit.Test;

public class ReporterTest
extends SystemTestCase4 {
    @Test
    public void reporterBasics() throws Exception {
        report.report("Report with only title");
        report.report("Title", "Internal message", true);
    }

    @Test
    public void reporterWithErrors() throws Exception {
        report.report("report with error", "internal message", 1);
    }

    @Test
    public void reporterWithException() throws Exception {
        report.report("report with exception", (Throwable)new Exception("An error"));
    }

    @Test
    public void reporterWithSteps() throws Exception {
        report.step("1. This is the first step");
        report.report("Some regular report element");
        report.step("2. Another step");
        report.report("Another regular report element");
    }

    @Test
    @TestProperties(name="Reporter with link to file", paramsInclude={""})
    public void reporterWithLinkToFile() throws Exception {
        File txtFile = File.createTempFile("someTempFile", ".txt");
        String content = "This is the file content. This is the file content";
        FileUtils.write((File)txtFile, (CharSequence)content);
        ReporterHelper.copyFileToReporterAndAddLink((Reporter)report, (File)txtFile, (String)"Some text file");
        txtFile.delete();
    }

    @Test
    public void reporterWithFailToPass() throws Exception {
        report.setFailToPass(true);
        try {
            report.report("fail to pass exception", (Throwable)new Exception("An error occured"));
            report.report("fail to pass flag", "internal message", false);
        }
        finally {
            report.setFailToPass(false);
        }
    }

    @Test
    public void reporterAddLink() throws Exception {
        report.addLink("My Link", "www.dummyLink.com");
    }

    @Test
    public void reporterWithGraph() throws Exception {
        Graph graph = GraphMonitorManager.getInstance().allocateGraph("Dummy graph of number of recieved packets in ping operation over time", "received packets");
        for (int i = 0; i < 10; ++i) {
            int receive = new Random().nextInt();
            graph.add("receive", (long)i, (double)receive);
        }
        graph.show(report);
    }

    @Test
    @TestProperties(name="Report with screenshot", paramsInclude={""})
    public void reporterWithScreenshot() throws Exception {
        ReporterHelper.copyFileToReporterAndAddLink((Reporter)report, (File)this.takeScreenshot(), (String)"Screenshot of your desktop");
    }

    private File takeScreenshot() throws Exception {
        Robot robot = new Robot();
        BufferedImage screenShot = robot.createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        File screenshotFile = File.createTempFile("screenshot", "jpg");
        ImageIO.write((RenderedImage)screenShot, "JPG", screenshotFile);
        return screenshotFile;
    }

    @Test
    @TestProperties(name="Test With Different Report Elements", paramsInclude={"file", "str", "i", "date", "strArr"})
    public void reporterWithDifferentReportElements() throws Exception {
        report.report("Only title");
        report.report("Title with message that was successful", "message", true);
        report.report("Title with message which faile", "message", false);
        File txtFile = new File("myText.txt");
        txtFile.createNewFile();
        FileUtils.write((File)txtFile, (CharSequence)"This is the file");
        ReporterHelper.copyFileToReporterAndAddLink((Reporter)report, (File)txtFile, (String)"This is the link title");
        txtFile.delete();
        report.startLevel("Start level", 2);
        report.report("In level 1");
        report.report("In level 1", true);
        report.startLevel("Start level 2", 2);
        report.report("In level2");
        report.stopLevel();
        report.stopLevel();
    }

    @Test
    @TestProperties(name="Reporter with complex levels", paramsInclude={""})
    public void reporterWithComplexLevels() throws Exception {
        report.startLevel("Starting level 0", 2);
        try {
            report.report("Inside level 0");
            report.report("Faliure inside level 0", false);
            report.report("Message inside level 0", "Some kind of message", true);
            report.report("Inside level 0");
            report.startLevel("Starting level 1", 2);
            try {
                report.report("Warning inside level 1", 2);
                report.report("Message inside level 1 - Level with warning", "Some kind of message", 2);
                ReporterHelper.copyFileToReporterAndAddLink((Reporter)report, (File)this.takeScreenshot(), (String)"Your screenshot");
                report.startLevel("Starting level 2", 2);
                try {
                    report.report("Success inside level 2", true);
                    report.report("Message inside level 2", "Some kind of message", true);
                    report.report("Inside level 2");
                    ReporterHelper.copyFileToReporterAndAddLink((Reporter)report, (File)this.takeScreenshot(), (String)"Your screenshot");
                }
                finally {
                    report.stopLevel();
                }
                report.report("Inside level 1");
            }
            finally {
                report.stopLevel();
            }
            report.report("Inside level 0");
        }
        finally {
            report.stopLevel();
        }
    }

    @Test
    public void reporterWithLeveling() throws Exception {
        report.startLevel("first level", 1);
        report.report("message in level 1");
        report.startLevel("second level", 0);
        report.report("message in level 2");
        report.startLevel("third level", 0);
        report.report("message in level 3");
        report.stopLevel();
        report.report("another message in level 2");
        report.stopLevel();
        report.report("another message in level 1");
        report.stopLevel();
        report.report("message in main report page");
    }

    @Test
    public void reporterWithInteractiveMessage() throws Exception {
        int res = report.showConfirmDialog("Confirm Dialog", "Continue test?", 0, 1);
        report.step("user reply = " + res);
    }

    @Test
    public void internalTests() throws Exception {
        for (int i = 0; i < 5; ++i) {
            report.startReport("testInternalTest" + i, "");
            report.report("in internal " + i, "this is my message", true);
            report.endReport();
        }
    }

    @Test
    public void reporterWithLinkToTest() throws Exception {
        String currentFullFileName = HtmlReporterUtils.getCurrentTestFileName();
        File reportPath = new File(report.getCurrentTestFolder()).getParentFile();
        String ref = jsystem.utils.FileUtils.getRelativePath((File)new File(currentFullFileName), (File)reportPath);
        ref = "./" + ref;
        Properties p = new Properties();
        p.setProperty("link to test", ref);
        p.setProperty("jsystem site", "http://jsystemtest.org");
        jsystem.utils.FileUtils.savePropertiesToFile((Properties)p, (String)"package.properties");
    }

    @Test
    public void reporterWithCustomHtml() {
        report.report("<table><tr><td>cell 1</td><td>cell 2</td></tr></table>", "<table><tr><td>cell 1</td><td>cell 2</td></tr></table>", 0, false, true, false, false);
    }
}

