/*
 * Decompiled with CFR 0.152.
 */
package com.aqua.services.multiuser;

import com.aqua.services.demo.WindowsStation;
import com.aqua.services.lifecycle.LifeTime;
import java.util.List;
import jsystem.framework.ParameterProperties;
import jsystem.framework.TestProperties;
import junit.framework.SystemTestCase;

public class SystemServicesTestWithAnnotations
extends SystemTestCase {
    private WindowsStation station;
    private String pingHost = "127.0.0.1";
    private LifeTime lifeTime = LifeTime.PERMANENT_LIFETIME;

    public void setUp() throws Exception {
        this.station = (WindowsStation)this.system.getSystemObject("station");
        this.station.setLifeTime(this.lifeTime.ordinal());
    }

    @TestProperties(name="Test ping operation on machine ${pingHost}, with SystemObject lifetime=${lifeTime}")
    public void testPing() throws Exception {
        this.station.ping(this.getPingHost());
    }

    @TestProperties(name="Demonstrates direct access to the SUT file", paramsInclude={})
    public void testDemonstrateDirectAccessToSUT() throws Exception {
        String setupName = this.sut().getSetupName();
        List allValues = this.sut().getAllValues("sut/station/*");
        String value = this.sut().getValue("sut/station/class/text()");
        SystemServicesTestWithAnnotations.assertEquals((String)"mystation.xml", (String)setupName);
        SystemServicesTestWithAnnotations.assertEquals((int)2, (int)allValues.size());
        SystemServicesTestWithAnnotations.assertEquals((String)"com.aqua.services.demo.WindowsStation", (String)value);
    }

    @TestProperties(name="Empty test to trigger fixtures navigation", paramsInclude={})
    public void testEmptyTest() {
    }

    public LifeTime getLifeTime() {
        return this.lifeTime;
    }

    @ParameterProperties(section="Lifetime")
    public void setLifeTime(LifeTime lifeTime) {
        this.lifeTime = lifeTime;
    }

    public String getPingHost() {
        return this.pingHost;
    }

    public String[] getPingHostOptions() {
        return new String[]{"127.0.0.1", "localhost", "192.16.45.1"};
    }

    @ParameterProperties(section="Target Host")
    public void setPingHost(String pingHost) {
        this.pingHost = pingHost;
    }

    public String[] sectionOrder() {
        return new String[]{"Target host", "Lifetime"};
    }
}

