/*
 * Decompiled with CFR 0.152.
 */
package com.aqua.services.lifecycle;

import com.aqua.services.demo.WindowsStation;
import com.aqua.services.lifecycle.LifeTime;
import java.util.Date;
import java.util.List;
import jsystem.framework.RunProperties;
import jsystem.framework.report.Summary;
import junit.framework.SystemTestCase;

public class SystemServicesTest
extends SystemTestCase {
    private WindowsStation station;
    private String pingHost = "127.0.0.1";
    private LifeTime lifeTime = LifeTime.PERMANENT_LIFETIME;

    public void setUp() throws Exception {
        this.station = (WindowsStation)this.system.getSystemObject("station1");
        this.station.setLifeTime(0);
    }

    public void testPing() throws Exception {
        this.station.ping(this.getPingHost());
    }

    public void testDemonstrateDirectAccessToSUT() throws Exception {
        String setupName = this.sut().getSetupName();
        List allValues = this.sut().getAllValues("sut/station/*");
        String value = this.sut().getValue("sut/station/class/text()");
        SystemServicesTest.assertEquals((String)"mystation.xml", (String)setupName);
        SystemServicesTest.assertEquals((int)2, (int)allValues.size());
        SystemServicesTest.assertEquals((String)"com.aqua.services.demo.WindowsStation", (String)value);
    }

    public void testRunPropertiesDemonstration() throws Exception {
        RunProperties.getInstance().setRunProperty("property", "value");
        Summary.getInstance().setProperty("time", new Date().toString());
    }

    public void testEmptyTest() {
    }

    public LifeTime getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(LifeTime lifeTime) {
        this.lifeTime = lifeTime;
    }

    public String getPingHost() {
        return this.pingHost;
    }

    public void setPingHost(String pingHost) {
        this.pingHost = pingHost;
    }
}

