/*
 * Decompiled with CFR 0.152.
 */
package com.aqua.services.analyzers;

import com.aqua.services.analyzers.SimpleTextFinder;
import com.aqua.services.demo.WindowsStation;
import jsystem.framework.analyzer.AnalyzerParameter;
import junit.framework.SystemTestCase;

public class AnalysisTest
extends SystemTestCase {
    private WindowsStation station;
    private String fileToFind = "golan.cap";
    private String folder = "";

    public void setUp() throws Exception {
        this.station = (WindowsStation)this.system.getSystemObject("station");
        this.station.setThrowException(true);
        report.setFailToPass(false);
    }

    public void testIsFileExists() throws Exception {
        this.station.dir(this.getFolder());
        this.station.analyze((AnalyzerParameter)new SimpleTextFinder(this.getFileToFind()));
    }

    public void testIsFileExistsIgnoreException() throws Exception {
        this.station.setThrowException(false);
        this.station.dir(this.getFolder());
        SimpleTextFinder analyzer = new SimpleTextFinder(this.getFileToFind());
        this.station.analyze((AnalyzerParameter)analyzer, true, false);
    }

    public void testIsFileExistsCheckAnalysisResults() throws Exception {
        this.station.dir(this.getFolder());
        boolean res = this.station.isAnalyzeSuccess((AnalyzerParameter)new SimpleTextFinder(this.getFileToFind()));
        report.report("Analysis results = " + res);
    }

    public void testIsFileExistsWarning() throws Exception {
        this.station.dir(this.getFolder());
        this.station.analyze((AnalyzerParameter)new SimpleTextFinder(this.getFileToFind()), false, false, true);
    }

    public String getFileToFind() {
        return this.fileToFind;
    }

    public void setFileToFind(String fileToFind) {
        this.fileToFind = fileToFind;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }
}

