/*
 * Decompiled with CFR 0.152.
 */
package javafx.fxml;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.builder.JavaFXFontBuilder;
import com.sun.javafx.fxml.builder.JavaFXImageBuilder;
import com.sun.javafx.fxml.builder.JavaFXSceneBuilder;
import com.sun.javafx.fxml.builder.ProxyBuilder;
import com.sun.javafx.fxml.builder.TriangleMeshBuilder;
import com.sun.javafx.fxml.builder.URLBuilder;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.reflect.ConstructorUtil;
import com.sun.javafx.reflect.MethodUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.text.Font;
import javafx.util.Builder;
import javafx.util.BuilderFactory;

public final class JavaFXBuilderFactory
implements BuilderFactory {
    private final ClassLoader classLoader;
    private final boolean webSupported;
    private static final String WEBVIEW_NAME = "javafx.scene.web.WebView";
    private static final String WEBVIEW_BUILDER_NAME = "com.sun.javafx.fxml.builder.web.WebViewBuilder";

    public JavaFXBuilderFactory() {
        this(FXMLLoader.getDefaultClassLoader());
    }

    public JavaFXBuilderFactory(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        this.classLoader = classLoader;
        this.webSupported = Platform.isSupported((ConditionalFeature)ConditionalFeature.WEB);
    }

    public Builder<?> getBuilder(Class<?> type) {
        Builder<Object> builder;
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == Scene.class) {
            builder = new JavaFXSceneBuilder();
        } else if (type == Font.class) {
            builder = new JavaFXFontBuilder();
        } else if (type == Image.class) {
            builder = new JavaFXImageBuilder();
        } else if (type == URL.class) {
            builder = new URLBuilder(this.classLoader);
        } else if (type == TriangleMesh.class) {
            builder = new TriangleMeshBuilder();
        } else if (this.webSupported && type.getName().equals(WEBVIEW_NAME)) {
            try {
                Class<?> builderClass = this.classLoader.loadClass(WEBVIEW_BUILDER_NAME);
                ObjectBuilderWrapper wrapper = new ObjectBuilderWrapper(builderClass);
                builder = wrapper.createBuilder();
            }
            catch (Exception ex) {
                builder = null;
            }
        } else {
            builder = this.scanForConstructorAnnotations(type) ? new ProxyBuilder(type) : null;
        }
        return builder;
    }

    private boolean scanForConstructorAnnotations(Class<?> type) {
        Constructor[] constructors;
        for (Constructor constructor : constructors = ConstructorUtil.getConstructors(type)) {
            Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                for (Annotation annotation : paramAnnotations[i]) {
                    if (!(annotation instanceof NamedArg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static final class ObjectBuilderWrapper {
        private static final Object[] NO_ARGS = new Object[0];
        private static final Class<?>[] NO_SIG = new Class[0];
        private final Class<?> builderClass;
        private final Method createMethod;
        private final Method buildMethod;
        private final Map<String, Method> methods = new HashMap<String, Method>();
        private final Map<String, Method> getters = new HashMap<String, Method>();
        private final Map<String, Method> setters = new HashMap<String, Method>();

        ObjectBuilderWrapper() {
            this.builderClass = null;
            this.createMethod = null;
            this.buildMethod = null;
        }

        ObjectBuilderWrapper(Class<?> builderClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException {
            this.builderClass = builderClass;
            this.createMethod = MethodUtil.getMethod(builderClass, (String)"create", (Class[])NO_SIG);
            this.buildMethod = MethodUtil.getMethod(builderClass, (String)"build", (Class[])NO_SIG);
            assert (Modifier.isStatic(this.createMethod.getModifiers()));
            assert (!Modifier.isStatic(this.buildMethod.getModifiers()));
        }

        Builder<Object> createBuilder() {
            return new ObjectBuilder();
        }

        private Method findMethod(String name) {
            if (((String)name).length() > 1 && Character.isUpperCase(((String)name).charAt(1))) {
                name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
            }
            for (Method m : MethodUtil.getMethods(this.builderClass)) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
            throw new IllegalArgumentException("Method " + (String)name + " could not be found at class " + this.builderClass.getName());
        }

        public Class<?> getTargetClass() {
            return this.buildMethod.getReturnType();
        }

        final class ObjectBuilder
        extends AbstractMap<String, Object>
        implements Builder<Object> {
            private final Map<String, Object> containers = new HashMap<String, Object>();
            private Object builder = null;
            private Map<Object, Object> properties;

            private ObjectBuilder() {
                try {
                    this.builder = ObjectBuilderWrapper.this.createMethod.invoke(null, NO_ARGS);
                }
                catch (Exception e) {
                    throw new RuntimeException("Creation of the builder " + ObjectBuilderWrapper.this.builderClass.getName() + " failed.", e);
                }
            }

            public Object build() {
                Object res;
                for (Map.Entry<String, Object> entry : this.containers.entrySet()) {
                    this.put(entry.getKey(), entry.getValue());
                }
                try {
                    res = ObjectBuilderWrapper.this.buildMethod.invoke(this.builder, NO_ARGS);
                    if (this.properties != null && res instanceof Node) {
                        ((Node)res).getProperties().putAll(this.properties);
                    }
                }
                catch (InvocationTargetException exception) {
                    throw new RuntimeException(exception);
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException(exception);
                }
                finally {
                    this.builder = null;
                }
                return res;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsKey(Object key) {
                return this.getTemporaryContainer(key.toString()) != null;
            }

            @Override
            public boolean containsValue(Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object get(Object key) {
                return this.getTemporaryContainer(key.toString());
            }

            @Override
            public Object put(String key, Object value) {
                if (Node.class.isAssignableFrom(ObjectBuilderWrapper.this.getTargetClass()) && "properties".equals(key)) {
                    this.properties = (Map)value;
                    return null;
                }
                try {
                    Method m = ObjectBuilderWrapper.this.methods.get(key);
                    if (m == null) {
                        m = ObjectBuilderWrapper.this.findMethod(key);
                        ObjectBuilderWrapper.this.methods.put(key, m);
                    }
                    try {
                        Class<?> type = m.getParameterTypes()[0];
                        if (type.isArray()) {
                            List<String> list = value instanceof List ? (List<String>)value : Arrays.asList(value.toString().split(","));
                            Class<?> componentType = type.getComponentType();
                            Object array = Array.newInstance(componentType, list.size());
                            for (int i = 0; i < list.size(); ++i) {
                                Array.set(array, i, BeanAdapter.coerce(list.get(i), componentType));
                            }
                            value = array;
                        }
                        m.invoke(this.builder, BeanAdapter.coerce(value, type));
                    }
                    catch (Exception e) {
                        String msg = "Method " + m.getName() + " failed";
                        PlatformLogger.getLogger((String)ObjectBuilderWrapper.class.getName()).warning(msg, (Throwable)e);
                    }
                    return null;
                }
                catch (Exception e) {
                    String msg = "Failed to set " + ObjectBuilderWrapper.this.getTargetClass() + "." + key + " using " + ObjectBuilderWrapper.this.builderClass;
                    PlatformLogger.getLogger((String)ObjectBuilderWrapper.class.getName()).warning(msg, (Throwable)e);
                    return null;
                }
            }

            Object getReadOnlyProperty(String propName) {
                Class<Object> type;
                if (ObjectBuilderWrapper.this.setters.get(propName) != null) {
                    return null;
                }
                Method getter = ObjectBuilderWrapper.this.getters.get(propName);
                if (getter == null) {
                    Method setter = null;
                    Class<?> target = ObjectBuilderWrapper.this.getTargetClass();
                    String suffix = Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
                    try {
                        getter = MethodUtil.getMethod(target, (String)("get" + suffix), (Class[])NO_SIG);
                        setter = MethodUtil.getMethod(target, (String)("set" + suffix), (Class[])new Class[]{getter.getReturnType()});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (getter != null) {
                        ObjectBuilderWrapper.this.getters.put(propName, getter);
                        ObjectBuilderWrapper.this.setters.put(propName, setter);
                    }
                    if (setter != null) {
                        return null;
                    }
                }
                if (getter == null) {
                    Method m = ObjectBuilderWrapper.this.findMethod(propName);
                    if (m == null) {
                        return null;
                    }
                    type = m.getParameterTypes()[0];
                    if (type.isArray()) {
                        type = List.class;
                    }
                } else {
                    type = getter.getReturnType();
                }
                if (ObservableMap.class.isAssignableFrom(type)) {
                    return FXCollections.observableMap(new HashMap());
                }
                if (Map.class.isAssignableFrom(type)) {
                    return new HashMap();
                }
                if (ObservableList.class.isAssignableFrom(type)) {
                    return FXCollections.observableArrayList();
                }
                if (List.class.isAssignableFrom(type)) {
                    return new ArrayList();
                }
                if (Set.class.isAssignableFrom(type)) {
                    return new HashSet();
                }
                return null;
            }

            public Object getTemporaryContainer(String propName) {
                Object o = this.containers.get(propName);
                if (o == null && (o = this.getReadOnlyProperty(propName)) != null) {
                    this.containers.put(propName, o);
                }
                return o;
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends Object> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<String> keySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> values() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

