/*
 * Decompiled with CFR 0.152.
 */
package javafx.fxml;

import com.sun.javafx.FXPermissions;
import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.FXMLLoaderHelper;
import com.sun.javafx.fxml.MethodHelper;
import com.sun.javafx.fxml.ParseTraceElement;
import com.sun.javafx.fxml.PropertyNotFoundException;
import com.sun.javafx.fxml.expression.Expression;
import com.sun.javafx.fxml.expression.ExpressionValue;
import com.sun.javafx.fxml.expression.KeyPath;
import com.sun.javafx.reflect.ConstructorUtil;
import com.sun.javafx.reflect.MethodUtil;
import com.sun.javafx.reflect.ReflectUtil;
import com.sun.javafx.util.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.fxml.LoadException;
import javafx.fxml.LoadListener;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import javafx.util.Callback;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class FXMLLoader {
    private static final RuntimePermission GET_CLASSLOADER_PERMISSION = new RuntimePermission("getClassLoader");
    private static final StackWalker walker = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
    private URL location;
    private ResourceBundle resources;
    private ObservableMap<String, Object> namespace = FXCollections.observableHashMap();
    private Object root = null;
    private Object controller = null;
    private BuilderFactory builderFactory;
    private Callback<Class<?>, Object> controllerFactory;
    private Charset charset;
    private final LinkedList<FXMLLoader> loaders;
    private ClassLoader classLoader = null;
    private boolean staticLoad = false;
    private LoadListener loadListener = null;
    private FXMLLoader parentLoader;
    private XMLStreamReader xmlStreamReader = null;
    private Element current = null;
    private ScriptEngine scriptEngine = null;
    private static boolean compileScript = true;
    private List<String> packages = new LinkedList<String>();
    private Map<String, Class<?>> classes = new HashMap();
    private ScriptEngineManager scriptEngineManager = null;
    private static ClassLoader defaultClassLoader = null;
    private static final Pattern extraneousWhitespacePattern = Pattern.compile("\\s+");
    private static BuilderFactory DEFAULT_BUILDER_FACTORY = new JavaFXBuilderFactory();
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String LANGUAGE_PROCESSING_INSTRUCTION = "language";
    public static final String IMPORT_PROCESSING_INSTRUCTION = "import";
    public static final String COMPILE_PROCESSING_INSTRUCTION = "compile";
    public static final String FX_NAMESPACE_PREFIX = "fx";
    public static final String FX_CONTROLLER_ATTRIBUTE = "controller";
    public static final String FX_ID_ATTRIBUTE = "id";
    public static final String FX_VALUE_ATTRIBUTE = "value";
    public static final String FX_CONSTANT_ATTRIBUTE = "constant";
    public static final String FX_FACTORY_ATTRIBUTE = "factory";
    public static final String INCLUDE_TAG = "include";
    public static final String INCLUDE_SOURCE_ATTRIBUTE = "source";
    public static final String INCLUDE_RESOURCES_ATTRIBUTE = "resources";
    public static final String INCLUDE_CHARSET_ATTRIBUTE = "charset";
    public static final String SCRIPT_TAG = "script";
    public static final String SCRIPT_SOURCE_ATTRIBUTE = "source";
    public static final String SCRIPT_CHARSET_ATTRIBUTE = "charset";
    public static final String DEFINE_TAG = "define";
    public static final String REFERENCE_TAG = "reference";
    public static final String REFERENCE_SOURCE_ATTRIBUTE = "source";
    public static final String ROOT_TAG = "root";
    public static final String ROOT_TYPE_ATTRIBUTE = "type";
    public static final String COPY_TAG = "copy";
    public static final String COPY_SOURCE_ATTRIBUTE = "source";
    public static final String EVENT_HANDLER_PREFIX = "on";
    public static final String EVENT_KEY = "event";
    public static final String CHANGE_EVENT_HANDLER_SUFFIX = "Change";
    private static final String COLLECTION_HANDLER_NAME = "onChange";
    public static final String NULL_KEYWORD = "null";
    public static final String ESCAPE_PREFIX = "\\";
    public static final String RELATIVE_PATH_PREFIX = "@";
    public static final String RESOURCE_KEY_PREFIX = "%";
    public static final String EXPRESSION_PREFIX = "$";
    public static final String BINDING_EXPRESSION_PREFIX = "${";
    public static final String BINDING_EXPRESSION_SUFFIX = "}";
    public static final String BI_DIRECTIONAL_BINDING_PREFIX = "#{";
    public static final String BI_DIRECTIONAL_BINDING_SUFFIX = "}";
    public static final String ARRAY_COMPONENT_DELIMITER = ",";
    public static final String LOCATION_KEY = "location";
    public static final String RESOURCES_KEY = "resources";
    public static final String CONTROLLER_METHOD_PREFIX = "#";
    public static final String CONTROLLER_KEYWORD = "controller";
    public static final String CONTROLLER_SUFFIX = "Controller";
    public static final String INITIALIZE_METHOD_NAME = "initialize";
    public static final String JAVAFX_VERSION = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("javafx.version");
        }
    });
    public static final String FX_NAMESPACE_VERSION = "1";
    private Class<?> callerClass;
    private final ControllerAccessor controllerAccessor = new ControllerAccessor();

    private void injectFields(String fieldName, Object value) throws LoadException {
        List<Field> fields;
        if (this.controller != null && fieldName != null && (fields = this.controllerAccessor.getControllerFields().get(fieldName)) != null) {
            try {
                for (Field f : fields) {
                    f.set(this.controller, value);
                }
            }
            catch (IllegalAccessException exception) {
                throw this.constructLoadException(exception);
            }
        }
    }

    public FXMLLoader() {
        this((URL)null);
    }

    public FXMLLoader(URL location) {
        this(location, null);
    }

    public FXMLLoader(URL location, ResourceBundle resources) {
        this(location, resources, null);
    }

    public FXMLLoader(URL location, ResourceBundle resources, BuilderFactory builderFactory) {
        this(location, resources, builderFactory, null);
    }

    public FXMLLoader(URL location, ResourceBundle resources, BuilderFactory builderFactory, Callback<Class<?>, Object> controllerFactory) {
        this(location, resources, builderFactory, controllerFactory, Charset.forName(DEFAULT_CHARSET_NAME));
    }

    public FXMLLoader(Charset charset) {
        this(null, null, null, null, charset);
    }

    public FXMLLoader(URL location, ResourceBundle resources, BuilderFactory builderFactory, Callback<Class<?>, Object> controllerFactory, Charset charset) {
        this(location, resources, builderFactory, controllerFactory, charset, new LinkedList<FXMLLoader>());
    }

    public FXMLLoader(URL location, ResourceBundle resources, BuilderFactory builderFactory, Callback<Class<?>, Object> controllerFactory, Charset charset, LinkedList<FXMLLoader> loaders) {
        this.setLocation(location);
        this.setResources(resources);
        this.setBuilderFactory(builderFactory);
        this.setControllerFactory(controllerFactory);
        this.setCharset(charset);
        this.loaders = new LinkedList<FXMLLoader>(loaders);
    }

    public URL getLocation() {
        return this.location;
    }

    public void setLocation(URL location) {
        this.location = location;
    }

    public ResourceBundle getResources() {
        return this.resources;
    }

    public void setResources(ResourceBundle resources) {
        this.resources = resources;
    }

    public ObservableMap<String, Object> getNamespace() {
        return this.namespace;
    }

    public <T> T getRoot() {
        return (T)this.root;
    }

    public void setRoot(Object root) {
        this.root = root;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FXMLLoader) {
            FXMLLoader loader = (FXMLLoader)obj;
            if (this.location == null || loader.location == null) {
                return loader.location == this.location;
            }
            return this.location.toExternalForm().equals(loader.location.toExternalForm());
        }
        return false;
    }

    private boolean isCyclic(FXMLLoader currentLoader, FXMLLoader node) {
        if (currentLoader == null) {
            return false;
        }
        if (currentLoader.equals(node)) {
            return true;
        }
        return this.isCyclic(currentLoader.parentLoader, node);
    }

    public <T> T getController() {
        return (T)this.controller;
    }

    public void setController(Object controller) {
        this.controller = controller;
        if (controller == null) {
            this.namespace.remove((Object)"controller");
        } else {
            this.namespace.put((Object)"controller", controller);
        }
        this.controllerAccessor.setController(controller);
    }

    public BuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    public void setBuilderFactory(BuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    public Callback<Class<?>, Object> getControllerFactory() {
        return this.controllerFactory;
    }

    public void setControllerFactory(Callback<Class<?>, Object> controllerFactory) {
        this.controllerFactory = controllerFactory;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is null.");
        }
        this.charset = charset;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            SecurityManager sm = System.getSecurityManager();
            Class<?> caller = sm != null ? walker.getCallerClass() : null;
            return FXMLLoader.getDefaultClassLoader(caller);
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException();
        }
        this.classLoader = classLoader;
        this.clearImports();
    }

    boolean isStaticLoad() {
        return this.staticLoad;
    }

    void setStaticLoad(boolean staticLoad) {
        this.staticLoad = staticLoad;
    }

    public LoadListener getLoadListener() {
        return this.loadListener;
    }

    public final void setLoadListener(LoadListener loadListener) {
        this.loadListener = loadListener;
    }

    public <T> T load() throws IOException {
        return this.loadImpl(System.getSecurityManager() != null ? walker.getCallerClass() : null);
    }

    public <T> T load(InputStream inputStream) throws IOException {
        return this.loadImpl(inputStream, System.getSecurityManager() != null ? walker.getCallerClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T loadImpl(Class<?> callerClass) throws IOException {
        T value;
        if (this.location == null) {
            throw new IllegalStateException("Location is not set.");
        }
        try (InputStream inputStream = null;){
            inputStream = this.location.openStream();
            value = this.loadImpl(inputStream, callerClass);
        }
        return value;
    }

    private <T> T loadImpl(InputStream inputStream, Class<?> callerClass) throws IOException {
        block23: {
            if (inputStream == null) {
                throw new NullPointerException("inputStream is null.");
            }
            this.callerClass = callerClass;
            this.controllerAccessor.setCallerClass(callerClass);
            try {
                this.clearImports();
                this.namespace.put((Object)LOCATION_KEY, (Object)this.location);
                this.namespace.put((Object)"resources", (Object)this.resources);
                this.scriptEngine = null;
                try {
                    XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                    xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.charset);
                    this.xmlStreamReader = new StreamReaderDelegate(xmlInputFactory.createXMLStreamReader(inputStreamReader)){

                        @Override
                        public String getPrefix() {
                            String prefix = super.getPrefix();
                            if (prefix != null && prefix.length() == 0) {
                                prefix = null;
                            }
                            return prefix;
                        }

                        @Override
                        public String getAttributePrefix(int index) {
                            String attributePrefix = super.getAttributePrefix(index);
                            if (attributePrefix != null && attributePrefix.length() == 0) {
                                attributePrefix = null;
                            }
                            return attributePrefix;
                        }
                    };
                }
                catch (XMLStreamException exception) {
                    throw this.constructLoadException(exception);
                }
                this.loaders.push(this);
                try {
                    while (this.xmlStreamReader.hasNext()) {
                        int event = this.xmlStreamReader.next();
                        switch (event) {
                            case 3: {
                                this.processProcessingInstruction();
                                break;
                            }
                            case 5: {
                                this.processComment();
                                break;
                            }
                            case 1: {
                                this.processStartElement();
                                break;
                            }
                            case 2: {
                                this.processEndElement();
                                break;
                            }
                            case 4: {
                                this.processCharacters();
                            }
                        }
                    }
                }
                catch (XMLStreamException exception) {
                    throw this.constructLoadException(exception);
                }
                if (this.controller == null) break block23;
                if (this.controller instanceof Initializable) {
                    ((Initializable)this.controller).initialize(this.location, this.resources);
                    break block23;
                }
                Map<String, List<Field>> controllerFields = this.controllerAccessor.getControllerFields();
                this.injectFields(LOCATION_KEY, this.location);
                this.injectFields("resources", this.resources);
                Method initializeMethod = this.controllerAccessor.getControllerMethods().get((Object)SupportedType.PARAMETERLESS).get(INITIALIZE_METHOD_NAME);
                if (initializeMethod == null) break block23;
                try {
                    MethodHelper.invoke(initializeMethod, this.controller, new Object[0]);
                }
                catch (IllegalAccessException exception) {
                    throw this.constructLoadException(exception);
                }
                catch (InvocationTargetException exception) {
                    throw this.constructLoadException(exception);
                }
            }
            catch (LoadException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw this.constructLoadException(exception);
            }
            finally {
                this.controllerAccessor.setCallerClass(null);
                this.controllerAccessor.reset();
                this.xmlStreamReader = null;
            }
        }
        return (T)this.root;
    }

    private void clearImports() {
        this.packages.clear();
        this.classes.clear();
    }

    private LoadException constructLoadException(String message) {
        return new LoadException(message + this.constructFXMLTrace());
    }

    private LoadException constructLoadException(Throwable cause) {
        return new LoadException(this.constructFXMLTrace(), cause);
    }

    private LoadException constructLoadException(String message, Throwable cause) {
        return new LoadException(message + this.constructFXMLTrace(), cause);
    }

    private String constructFXMLTrace() {
        StringBuilder messageBuilder = new StringBuilder("\n");
        for (FXMLLoader loader : this.loaders) {
            messageBuilder.append(loader.location != null ? loader.location.getPath() : "unknown path");
            if (loader.current != null) {
                messageBuilder.append(":");
                messageBuilder.append(loader.getLineNumber());
            }
            messageBuilder.append("\n");
        }
        return messageBuilder.toString();
    }

    int getLineNumber() {
        return this.xmlStreamReader.getLocation().getLineNumber();
    }

    ParseTraceElement[] getParseTrace() {
        ParseTraceElement[] parseTrace = new ParseTraceElement[this.loaders.size()];
        int i = 0;
        for (FXMLLoader loader : this.loaders) {
            parseTrace[i++] = new ParseTraceElement(loader.location, loader.current != null ? loader.getLineNumber() : -1);
        }
        return parseTrace;
    }

    private void processProcessingInstruction() throws LoadException {
        String piTarget = this.xmlStreamReader.getPITarget().trim();
        if (piTarget.equals(LANGUAGE_PROCESSING_INSTRUCTION)) {
            this.processLanguage();
        } else if (piTarget.equals(IMPORT_PROCESSING_INSTRUCTION)) {
            this.processImport();
        } else if (piTarget.equals(COMPILE_PROCESSING_INSTRUCTION)) {
            String strCompile = this.xmlStreamReader.getPIData().trim();
            compileScript = strCompile.length() == 0 ? true : Boolean.parseBoolean(strCompile);
        }
    }

    private void processLanguage() throws LoadException {
        if (this.scriptEngine != null) {
            throw this.constructLoadException("Page language already set.");
        }
        String language = this.xmlStreamReader.getPIData();
        if (this.loadListener != null) {
            this.loadListener.readLanguageProcessingInstruction(language);
        }
        if (!this.staticLoad) {
            ScriptEngineManager scriptEngineManager = this.getScriptEngineManager();
            this.scriptEngine = scriptEngineManager.getEngineByName(language);
        }
    }

    private void processImport() throws LoadException {
        String target = this.xmlStreamReader.getPIData().trim();
        if (this.loadListener != null) {
            this.loadListener.readImportProcessingInstruction(target);
        }
        if (target.endsWith(".*")) {
            this.importPackage(target.substring(0, target.length() - 2));
        } else {
            this.importClass(target);
        }
    }

    private void processComment() throws LoadException {
        if (this.loadListener != null) {
            this.loadListener.readComment(this.xmlStreamReader.getText());
        }
    }

    private void processStartElement() throws IOException {
        this.createElement();
        this.current.processStartElement();
        if (this.root == null) {
            this.root = this.current.value;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createElement() throws IOException {
        String prefix = this.xmlStreamReader.getPrefix();
        String localName = this.xmlStreamReader.getLocalName();
        if (prefix == null) {
            int i = localName.lastIndexOf(46);
            if (Character.isLowerCase(localName.charAt(i + 1))) {
                String name = localName.substring(i + 1);
                if (i == -1) {
                    if (this.loadListener != null) {
                        this.loadListener.beginPropertyElement(name, null);
                    }
                    this.current = new PropertyElement(name, null);
                    return;
                } else {
                    Class<?> sourceType = this.getType(localName.substring(0, i));
                    if (sourceType != null) {
                        if (this.loadListener != null) {
                            this.loadListener.beginPropertyElement(name, sourceType);
                        }
                        this.current = new PropertyElement(name, sourceType);
                        return;
                    } else {
                        if (!this.staticLoad) throw this.constructLoadException(localName + " is not a valid property.");
                        if (this.loadListener != null) {
                            this.loadListener.beginUnknownStaticPropertyElement(localName);
                        }
                        this.current = new UnknownStaticPropertyElement();
                    }
                }
                return;
            } else {
                if (this.current == null && this.root != null) {
                    throw this.constructLoadException("Root value already specified.");
                }
                Class<?> type = this.getType(localName);
                if (type != null) {
                    if (this.loadListener != null) {
                        this.loadListener.beginInstanceDeclarationElement(type);
                    }
                    this.current = new InstanceDeclarationElement(type);
                    return;
                } else {
                    if (!this.staticLoad) throw this.constructLoadException(localName + " is not a valid type.");
                    if (this.loadListener != null) {
                        this.loadListener.beginUnknownTypeElement(localName);
                    }
                    this.current = new UnknownTypeElement();
                }
            }
            return;
        } else {
            if (!prefix.equals(FX_NAMESPACE_PREFIX)) throw this.constructLoadException("Unexpected namespace prefix: " + prefix + ".");
            if (localName.equals(INCLUDE_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginIncludeElement();
                }
                this.current = new IncludeElement();
                return;
            } else if (localName.equals(REFERENCE_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginReferenceElement();
                }
                this.current = new ReferenceElement();
                return;
            } else if (localName.equals(COPY_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginCopyElement();
                }
                this.current = new CopyElement();
                return;
            } else if (localName.equals(ROOT_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginRootElement();
                }
                this.current = new RootElement();
                return;
            } else if (localName.equals(SCRIPT_TAG)) {
                if (this.loadListener != null) {
                    this.loadListener.beginScriptElement();
                }
                this.current = new ScriptElement();
                return;
            } else {
                if (!localName.equals(DEFINE_TAG)) throw this.constructLoadException(prefix + ":" + localName + " is not a valid element.");
                if (this.loadListener != null) {
                    this.loadListener.beginDefineElement();
                }
                this.current = new DefineElement();
            }
        }
    }

    private void processEndElement() throws IOException {
        this.current.processEndElement();
        if (this.loadListener != null) {
            this.loadListener.endElement(this.current.value);
        }
        this.current = this.current.parent;
    }

    private void processCharacters() throws IOException {
        if (!this.xmlStreamReader.isWhiteSpace()) {
            this.current.processCharacters();
        }
    }

    private void importPackage(String name) throws LoadException {
        this.packages.add(name);
    }

    private void importClass(String name) throws LoadException {
        try {
            this.loadType(name, true);
        }
        catch (ClassNotFoundException exception) {
            throw this.constructLoadException(exception);
        }
    }

    private Class<?> getType(String name) throws LoadException {
        Class<?> type = null;
        if (Character.isLowerCase(name.charAt(0))) {
            try {
                type = this.loadType(name, false);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            type = this.classes.get(name);
            if (type == null) {
                for (String packageName : this.packages) {
                    try {
                        type = this.loadTypeForPackage(packageName, name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (type == null) continue;
                    break;
                }
                if (type != null) {
                    this.classes.put(name, type);
                }
            }
        }
        return type;
    }

    private Class<?> loadType(String name, boolean cache) throws ClassNotFoundException {
        int i = name.indexOf(46);
        int n = name.length();
        while (i != -1 && i < n && Character.isLowerCase(name.charAt(i + 1))) {
            i = name.indexOf(46, i + 1);
        }
        if (i == -1 || i == n) {
            throw new ClassNotFoundException();
        }
        String packageName = name.substring(0, i);
        String className = name.substring(i + 1);
        Class<?> type = this.loadTypeForPackage(packageName, className);
        if (cache) {
            this.classes.put(className, type);
        }
        return type;
    }

    private Class<?> loadTypeForPackage(String packageName, String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(packageName + "." + className.replace('.', '$'));
    }

    private static SupportedType toSupportedType(Method m) {
        for (SupportedType t : SupportedType.values()) {
            if (!t.methodIsOfType(m)) continue;
            return t;
        }
        return null;
    }

    private ScriptEngineManager getScriptEngineManager() {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager();
            this.scriptEngineManager.setBindings(new SimpleBindings((Map<String, Object>)this.namespace));
        }
        return this.scriptEngineManager;
    }

    @Deprecated
    public static Class<?> loadType(String packageName, String className) throws ClassNotFoundException {
        return FXMLLoader.loadType(packageName + "." + className.replace('.', '$'));
    }

    @Deprecated
    public static Class<?> loadType(String className) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess((String)className);
        return Class.forName(className, true, FXMLLoader.getDefaultClassLoader());
    }

    private static boolean needsClassLoaderPermissionCheck(Class caller) {
        if (caller == null) {
            return false;
        }
        return !FXMLLoader.class.getModule().equals(caller.getModule());
    }

    private static ClassLoader getDefaultClassLoader(Class caller) {
        if (defaultClassLoader == null) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && FXMLLoader.needsClassLoaderPermissionCheck(caller)) {
                sm.checkPermission(GET_CLASSLOADER_PERMISSION);
            }
            return Thread.currentThread().getContextClassLoader();
        }
        return defaultClassLoader;
    }

    public static ClassLoader getDefaultClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        Class<?> caller = sm != null ? walker.getCallerClass() : null;
        return FXMLLoader.getDefaultClassLoader(caller);
    }

    public static void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        if (defaultClassLoader == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)FXPermissions.MODIFY_FXML_CLASS_LOADER_PERMISSION);
        }
        FXMLLoader.defaultClassLoader = defaultClassLoader;
    }

    public static <T> T load(URL location) throws IOException {
        return FXMLLoader.loadImpl(location, System.getSecurityManager() != null ? walker.getCallerClass() : null);
    }

    private static <T> T loadImpl(URL location, Class<?> callerClass) throws IOException {
        return FXMLLoader.loadImpl(location, null, callerClass);
    }

    public static <T> T load(URL location, ResourceBundle resources) throws IOException {
        return FXMLLoader.loadImpl(location, resources, System.getSecurityManager() != null ? walker.getCallerClass() : null);
    }

    private static <T> T loadImpl(URL location, ResourceBundle resources, Class<?> callerClass) throws IOException {
        return FXMLLoader.loadImpl(location, resources, null, callerClass);
    }

    public static <T> T load(URL location, ResourceBundle resources, BuilderFactory builderFactory) throws IOException {
        return FXMLLoader.loadImpl(location, resources, builderFactory, System.getSecurityManager() != null ? walker.getCallerClass() : null);
    }

    private static <T> T loadImpl(URL location, ResourceBundle resources, BuilderFactory builderFactory, Class<?> callerClass) throws IOException {
        return FXMLLoader.loadImpl(location, resources, builderFactory, null, callerClass);
    }

    public static <T> T load(URL location, ResourceBundle resources, BuilderFactory builderFactory, Callback<Class<?>, Object> controllerFactory) throws IOException {
        return FXMLLoader.loadImpl(location, resources, builderFactory, controllerFactory, System.getSecurityManager() != null ? walker.getCallerClass() : null);
    }

    private static <T> T loadImpl(URL location, ResourceBundle resources, BuilderFactory builderFactory, Callback<Class<?>, Object> controllerFactory, Class<?> callerClass) throws IOException {
        return FXMLLoader.loadImpl(location, resources, builderFactory, controllerFactory, Charset.forName(DEFAULT_CHARSET_NAME), callerClass);
    }

    public static <T> T load(URL location, ResourceBundle resources, BuilderFactory builderFactory, Callback<Class<?>, Object> controllerFactory, Charset charset) throws IOException {
        return FXMLLoader.loadImpl(location, resources, builderFactory, controllerFactory, charset, System.getSecurityManager() != null ? walker.getCallerClass() : null);
    }

    private static <T> T loadImpl(URL location, ResourceBundle resources, BuilderFactory builderFactory, Callback<Class<?>, Object> controllerFactory, Charset charset, Class<?> callerClass) throws IOException {
        if (location == null) {
            throw new NullPointerException("Location is required.");
        }
        FXMLLoader fxmlLoader = new FXMLLoader(location, resources, builderFactory, controllerFactory, charset);
        return fxmlLoader.loadImpl(callerClass);
    }

    static int compareJFXVersions(String rtVer, String nsVer) {
        int underIndex;
        int retVal = 0;
        if (rtVer == null || "".equals(rtVer) || nsVer == null || "".equals(nsVer)) {
            return retVal;
        }
        if (rtVer.equals(nsVer)) {
            return retVal;
        }
        int dashIndex = rtVer.indexOf("-");
        if (dashIndex > 0) {
            rtVer = rtVer.substring(0, dashIndex);
        }
        if ((underIndex = rtVer.indexOf("_")) > 0) {
            rtVer = rtVer.substring(0, underIndex);
        }
        if (!Pattern.matches("^(\\d+)(\\.\\d+)*$", rtVer) || !Pattern.matches("^(\\d+)(\\.\\d+)*$", nsVer)) {
            return retVal;
        }
        StringTokenizer nsVerTokenizer = new StringTokenizer(nsVer, ".");
        StringTokenizer rtVerTokenizer = new StringTokenizer(rtVer, ".");
        int nsDigit = 0;
        int rtDigit = 0;
        boolean rtVerEnd = false;
        while (nsVerTokenizer.hasMoreTokens() && retVal == 0) {
            nsDigit = Integer.parseInt(nsVerTokenizer.nextToken());
            if (rtVerTokenizer.hasMoreTokens()) {
                rtDigit = Integer.parseInt(rtVerTokenizer.nextToken());
                retVal = rtDigit - nsDigit;
                continue;
            }
            rtVerEnd = true;
            break;
        }
        if (rtVerTokenizer.hasMoreTokens() && retVal == 0 && (rtDigit = Integer.parseInt(rtVerTokenizer.nextToken())) > 0) {
            retVal = 1;
        }
        if (rtVerEnd) {
            if (nsDigit > 0) {
                retVal = -1;
            } else {
                while (nsVerTokenizer.hasMoreTokens()) {
                    nsDigit = Integer.parseInt(nsVerTokenizer.nextToken());
                    if (nsDigit <= 0) continue;
                    retVal = -1;
                    break;
                }
            }
        }
        return retVal;
    }

    private static void checkClassLoaderPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)FXPermissions.MODIFY_FXML_CLASS_LOADER_PERMISSION);
        }
    }

    static {
        FXMLLoaderHelper.setFXMLLoaderAccessor(new FXMLLoaderHelper.FXMLLoaderAccessor(){

            @Override
            public void setStaticLoad(FXMLLoader fxmlLoader, boolean staticLoad) {
                fxmlLoader.setStaticLoad(staticLoad);
            }
        });
    }

    private static final class ControllerAccessor {
        private static final int PUBLIC = 1;
        private static final int PROTECTED = 2;
        private static final int PACKAGE = 4;
        private static final int PRIVATE = 8;
        private static final int INITIAL_CLASS_ACCESS = 15;
        private static final int INITIAL_MEMBER_ACCESS = 15;
        private static final int METHODS = 0;
        private static final int FIELDS = 1;
        private Object controller;
        private ClassLoader callerClassLoader;
        private Map<String, List<Field>> controllerFields;
        private Map<SupportedType, Map<String, Method>> controllerMethods;

        private ControllerAccessor() {
        }

        void setController(Object controller) {
            if (this.controller != controller) {
                this.controller = controller;
                this.reset();
            }
        }

        void setCallerClass(Class<?> callerClass) {
            ClassLoader newCallerClassLoader;
            ClassLoader classLoader = newCallerClassLoader = callerClass != null ? callerClass.getClassLoader() : null;
            if (this.callerClassLoader != newCallerClassLoader) {
                this.callerClassLoader = newCallerClassLoader;
                this.reset();
            }
        }

        void reset() {
            this.controllerFields = null;
            this.controllerMethods = null;
        }

        Map<String, List<Field>> getControllerFields() {
            if (this.controllerFields == null) {
                this.controllerFields = new HashMap<String, List<Field>>();
                if (this.callerClassLoader == null) {
                    FXMLLoader.checkClassLoaderPermission();
                }
                this.addAccessibleMembers(this.controller.getClass(), 15, 15, 1);
            }
            return this.controllerFields;
        }

        Map<SupportedType, Map<String, Method>> getControllerMethods() {
            if (this.controllerMethods == null) {
                this.controllerMethods = new EnumMap<SupportedType, Map<String, Method>>(SupportedType.class);
                for (SupportedType t : SupportedType.values()) {
                    this.controllerMethods.put(t, new HashMap());
                }
                if (this.callerClassLoader == null) {
                    FXMLLoader.checkClassLoaderPermission();
                }
                this.addAccessibleMembers(this.controller.getClass(), 15, 15, 0);
            }
            return this.controllerMethods;
        }

        private void addAccessibleMembers(final Class<?> type, int prevAllowedClassAccess, int prevAllowedMemberAccess, final int membersType) {
            int classAccess;
            if (type == Object.class) {
                return;
            }
            int allowedClassAccess = prevAllowedClassAccess;
            int allowedMemberAccess = prevAllowedMemberAccess;
            if (this.callerClassLoader != null && type.getClassLoader() != this.callerClassLoader) {
                allowedClassAccess &= 1;
                allowedMemberAccess &= 1;
            }
            if (((classAccess = ControllerAccessor.getAccess(type.getModifiers())) & allowedClassAccess) == 0) {
                return;
            }
            ReflectUtil.checkPackageAccess(type);
            this.addAccessibleMembers(type.getSuperclass(), allowedClassAccess, allowedMemberAccess, membersType);
            final int finalAllowedMemberAccess = allowedMemberAccess;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (membersType == 1) {
                        this.addAccessibleFields(type, finalAllowedMemberAccess);
                    } else {
                        this.addAccessibleMethods(type, finalAllowedMemberAccess);
                    }
                    return null;
                }
            });
        }

        private void addAccessibleFields(Class<?> type, int allowedMemberAccess) {
            boolean isPublicType = Modifier.isPublic(type.getModifiers());
            Field[] fields = type.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                List<Field> list;
                Field field = fields[i];
                int memberModifiers = field.getModifiers();
                if ((memberModifiers & 0x18) != 0 || (ControllerAccessor.getAccess(memberModifiers) & allowedMemberAccess) == 0) continue;
                if (!isPublicType || !Modifier.isPublic(memberModifiers)) {
                    if (field.getAnnotation(FXML.class) == null) continue;
                    field.setAccessible(true);
                }
                if ((list = this.controllerFields.get(field.getName())) == null) {
                    list = new ArrayList<Field>(1);
                    this.controllerFields.put(field.getName(), list);
                }
                list.add(field);
            }
        }

        private void addAccessibleMethods(Class<?> type, int allowedMemberAccess) {
            boolean isPublicType = Modifier.isPublic(type.getModifiers());
            Method[] methods = type.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                int memberModifiers = method.getModifiers();
                if ((memberModifiers & 0x108) != 0 || (ControllerAccessor.getAccess(memberModifiers) & allowedMemberAccess) == 0) continue;
                if (!isPublicType || !Modifier.isPublic(memberModifiers)) {
                    if (method.getAnnotation(FXML.class) == null) continue;
                    method.setAccessible(true);
                }
                String methodName = method.getName();
                SupportedType convertedType = FXMLLoader.toSupportedType(method);
                if (convertedType == null) continue;
                this.controllerMethods.get((Object)convertedType).put(methodName, method);
            }
        }

        private static int getAccess(int fullModifiers) {
            int untransformedAccess = fullModifiers & 7;
            switch (untransformedAccess) {
                case 1: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 2: {
                    return 8;
                }
            }
            return 4;
        }
    }

    private abstract class Element {
        public final Element parent;
        public Object value = null;
        private BeanAdapter valueAdapter = null;
        public final LinkedList<Attribute> eventHandlerAttributes = new LinkedList();
        public final LinkedList<Attribute> instancePropertyAttributes = new LinkedList();
        public final LinkedList<Attribute> staticPropertyAttributes = new LinkedList();
        public final LinkedList<PropertyElement> staticPropertyElements = new LinkedList();

        public Element() {
            this.parent = FXMLLoader.this.current;
        }

        public boolean isCollection() {
            Class<?> type;
            DefaultProperty defaultProperty;
            boolean collection = this.value instanceof List ? true : ((defaultProperty = (type = this.value.getClass()).getAnnotation(DefaultProperty.class)) != null ? this.getProperties().get(defaultProperty.value()) instanceof List : false);
            return collection;
        }

        public void add(Object element) throws LoadException {
            List list;
            if (this.value instanceof List) {
                list = (List)this.value;
            } else {
                Class<?> type = this.value.getClass();
                DefaultProperty defaultProperty = type.getAnnotation(DefaultProperty.class);
                String defaultPropertyName = defaultProperty.value();
                list = (List)this.getProperties().get(defaultPropertyName);
                if (!Map.class.isAssignableFrom(type)) {
                    Type listType = this.getValueAdapter().getGenericType(defaultPropertyName);
                    element = BeanAdapter.coerce(element, BeanAdapter.getListItemType(listType));
                }
            }
            list.add(element);
        }

        public void set(Object value) throws LoadException {
            if (this.value == null) {
                throw FXMLLoader.this.constructLoadException("Cannot set value on this element.");
            }
            Class<?> type = this.value.getClass();
            DefaultProperty defaultProperty = type.getAnnotation(DefaultProperty.class);
            if (defaultProperty == null) {
                throw FXMLLoader.this.constructLoadException("Element does not define a default property.");
            }
            this.getProperties().put(defaultProperty.value(), value);
        }

        public void updateValue(Object value) {
            this.value = value;
            this.valueAdapter = null;
        }

        public boolean isTyped() {
            return !(this.value instanceof Map);
        }

        public BeanAdapter getValueAdapter() {
            if (this.valueAdapter == null) {
                this.valueAdapter = new BeanAdapter(this.value);
            }
            return this.valueAdapter;
        }

        public Map<String, Object> getProperties() {
            return this.isTyped() ? this.getValueAdapter() : (Map)this.value;
        }

        public void processStartElement() throws IOException {
            int n = FXMLLoader.this.xmlStreamReader.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String prefix = FXMLLoader.this.xmlStreamReader.getAttributePrefix(i);
                String localName = FXMLLoader.this.xmlStreamReader.getAttributeLocalName(i);
                String value = FXMLLoader.this.xmlStreamReader.getAttributeValue(i);
                if (FXMLLoader.this.loadListener != null && prefix != null && prefix.equals(FXMLLoader.FX_NAMESPACE_PREFIX)) {
                    FXMLLoader.this.loadListener.readInternalAttribute(prefix + ":" + localName, value);
                }
                this.processAttribute(prefix, localName, value);
            }
        }

        public void processEndElement() throws IOException {
        }

        public void processCharacters() throws IOException {
            throw FXMLLoader.this.constructLoadException("Unexpected characters in input stream.");
        }

        public void processInstancePropertyAttributes() throws IOException {
            if (this.instancePropertyAttributes.size() > 0) {
                for (Attribute attribute : this.instancePropertyAttributes) {
                    this.processPropertyAttribute(attribute);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void processAttribute(String prefix, String localName, String value) throws IOException {
            if (prefix != null) throw FXMLLoader.this.constructLoadException(prefix + ":" + localName + " is not a valid attribute.");
            if (localName.startsWith(FXMLLoader.EVENT_HANDLER_PREFIX)) {
                if (FXMLLoader.this.loadListener != null) {
                    FXMLLoader.this.loadListener.readEventHandlerAttribute(localName, value);
                }
                this.eventHandlerAttributes.add(new Attribute(localName, null, value));
                return;
            } else {
                int i = localName.lastIndexOf(46);
                if (i == -1) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readPropertyAttribute(localName, null, value);
                    }
                    this.instancePropertyAttributes.add(new Attribute(localName, null, value));
                    return;
                } else {
                    String name = localName.substring(i + 1);
                    Class<?> sourceType = FXMLLoader.this.getType(localName.substring(0, i));
                    if (sourceType != null) {
                        if (FXMLLoader.this.loadListener != null) {
                            FXMLLoader.this.loadListener.readPropertyAttribute(name, sourceType, value);
                        }
                        this.staticPropertyAttributes.add(new Attribute(name, sourceType, value));
                        return;
                    } else {
                        if (!FXMLLoader.this.staticLoad) throw FXMLLoader.this.constructLoadException(localName + " is not a valid attribute.");
                        if (FXMLLoader.this.loadListener == null) return;
                        FXMLLoader.this.loadListener.readUnknownStaticPropertyAttribute(localName, value);
                    }
                }
            }
        }

        public void processPropertyAttribute(Attribute attribute) throws IOException {
            String value = attribute.value;
            if (this.isBindingExpression(value)) {
                if (attribute.sourceType != null) {
                    throw FXMLLoader.this.constructLoadException("Cannot bind to static property.");
                }
                if (!this.isTyped()) {
                    throw FXMLLoader.this.constructLoadException("Cannot bind to untyped object.");
                }
                if (this.value instanceof Builder) {
                    throw FXMLLoader.this.constructLoadException("Cannot bind to builder property.");
                }
                if (!FXMLLoader.this.isStaticLoad()) {
                    value = value.substring(FXMLLoader.BINDING_EXPRESSION_PREFIX.length(), value.length() - 1);
                    Expression expression = Expression.valueOf(value);
                    BeanAdapter targetAdapter = new BeanAdapter(this.value);
                    ObservableValue propertyModel = targetAdapter.getPropertyModel(attribute.name);
                    Class<?> type = targetAdapter.getType(attribute.name);
                    if (propertyModel instanceof Property) {
                        ((Property)propertyModel).bind((ObservableValue)new ExpressionValue(FXMLLoader.this.namespace, expression, type));
                    }
                }
            } else {
                if (this.isBidirectionalBindingExpression(value)) {
                    throw FXMLLoader.this.constructLoadException(new UnsupportedOperationException("This feature is not currently enabled."));
                }
                this.processValue(attribute.sourceType, attribute.name, value);
            }
        }

        private boolean isBindingExpression(String aValue) {
            return aValue.startsWith(FXMLLoader.BINDING_EXPRESSION_PREFIX) && aValue.endsWith("}");
        }

        private boolean isBidirectionalBindingExpression(String aValue) {
            return aValue.startsWith(FXMLLoader.BI_DIRECTIONAL_BINDING_PREFIX);
        }

        private boolean processValue(Class sourceType, String propertyName, String aValue) throws LoadException {
            boolean processed = false;
            if (sourceType == null && this.isTyped()) {
                BeanAdapter valueAdapter = this.getValueAdapter();
                Class<?> type = valueAdapter.getType(propertyName);
                if (type == null) {
                    throw new PropertyNotFoundException("Property \"" + propertyName + "\" does not exist or is read-only.");
                }
                if (List.class.isAssignableFrom(type) && valueAdapter.isReadOnly(propertyName)) {
                    this.populateListFromString(valueAdapter, propertyName, aValue);
                    processed = true;
                } else if (type.isArray()) {
                    this.applyProperty(propertyName, sourceType, this.populateArrayFromString(type, aValue));
                    processed = true;
                }
            }
            if (!processed) {
                this.applyProperty(propertyName, sourceType, this.resolvePrefixedValue(aValue));
                processed = true;
            }
            return processed;
        }

        private Object resolvePrefixedValue(String aValue) throws LoadException {
            if (aValue.startsWith(FXMLLoader.ESCAPE_PREFIX)) {
                if (!((aValue = aValue.substring(FXMLLoader.ESCAPE_PREFIX.length())).length() != 0 && (aValue.startsWith(FXMLLoader.ESCAPE_PREFIX) || aValue.startsWith(FXMLLoader.RELATIVE_PATH_PREFIX) || aValue.startsWith(FXMLLoader.RESOURCE_KEY_PREFIX) || aValue.startsWith(FXMLLoader.EXPRESSION_PREFIX) || aValue.startsWith(FXMLLoader.BI_DIRECTIONAL_BINDING_PREFIX)))) {
                    throw FXMLLoader.this.constructLoadException("Invalid escape sequence.");
                }
                return aValue;
            }
            if (aValue.startsWith(FXMLLoader.RELATIVE_PATH_PREFIX)) {
                if ((aValue = aValue.substring(FXMLLoader.RELATIVE_PATH_PREFIX.length())).length() == 0) {
                    throw FXMLLoader.this.constructLoadException("Missing relative path.");
                }
                if (aValue.startsWith(FXMLLoader.RELATIVE_PATH_PREFIX)) {
                    this.warnDeprecatedEscapeSequence(FXMLLoader.RELATIVE_PATH_PREFIX);
                    return aValue;
                }
                if (aValue.charAt(0) == '/') {
                    URL res = FXMLLoader.this.getClassLoader().getResource(aValue.substring(1));
                    if (res == null) {
                        throw FXMLLoader.this.constructLoadException("Invalid resource: " + aValue + " not found on the classpath");
                    }
                    return res.toString();
                }
                try {
                    return new URL(FXMLLoader.this.location, aValue).toString();
                }
                catch (MalformedURLException e) {
                    System.err.println(FXMLLoader.this.location + "/" + aValue);
                }
            } else {
                if (aValue.startsWith(FXMLLoader.RESOURCE_KEY_PREFIX)) {
                    if ((aValue = aValue.substring(FXMLLoader.RESOURCE_KEY_PREFIX.length())).length() == 0) {
                        throw FXMLLoader.this.constructLoadException("Missing resource key.");
                    }
                    if (aValue.startsWith(FXMLLoader.RESOURCE_KEY_PREFIX)) {
                        this.warnDeprecatedEscapeSequence(FXMLLoader.RESOURCE_KEY_PREFIX);
                        return aValue;
                    }
                    if (FXMLLoader.this.resources == null) {
                        throw FXMLLoader.this.constructLoadException("No resources specified.");
                    }
                    if (!FXMLLoader.this.resources.containsKey(aValue)) {
                        throw FXMLLoader.this.constructLoadException("Resource \"" + aValue + "\" not found.");
                    }
                    return FXMLLoader.this.resources.getString(aValue);
                }
                if (aValue.startsWith(FXMLLoader.EXPRESSION_PREFIX)) {
                    if ((aValue = aValue.substring(FXMLLoader.EXPRESSION_PREFIX.length())).length() == 0) {
                        throw FXMLLoader.this.constructLoadException("Missing expression.");
                    }
                    if (aValue.startsWith(FXMLLoader.EXPRESSION_PREFIX)) {
                        this.warnDeprecatedEscapeSequence(FXMLLoader.EXPRESSION_PREFIX);
                        return aValue;
                    }
                    if (aValue.equals(FXMLLoader.NULL_KEYWORD)) {
                        return null;
                    }
                    return Expression.get(FXMLLoader.this.namespace, KeyPath.parse(aValue));
                }
            }
            return aValue;
        }

        private Object populateArrayFromString(Class<?> type, String stringValue) throws LoadException {
            Object propertyValue = null;
            Class<?> componentType = type.getComponentType();
            if (stringValue.length() > 0) {
                String[] values = stringValue.split(FXMLLoader.ARRAY_COMPONENT_DELIMITER);
                propertyValue = Array.newInstance(componentType, values.length);
                for (int i = 0; i < values.length; ++i) {
                    Array.set(propertyValue, i, BeanAdapter.coerce(this.resolvePrefixedValue(values[i].trim()), type.getComponentType()));
                }
            } else {
                propertyValue = Array.newInstance(componentType, 0);
            }
            return propertyValue;
        }

        private void populateListFromString(BeanAdapter valueAdapter, String listPropertyName, String stringValue) throws LoadException {
            List list = (List)valueAdapter.get((Object)listPropertyName);
            Type listType = valueAdapter.getGenericType(listPropertyName);
            Type itemType = (Class)BeanAdapter.getGenericListItemType(listType);
            if (itemType instanceof ParameterizedType) {
                itemType = ((ParameterizedType)itemType).getRawType();
            }
            if (stringValue.length() > 0) {
                String[] values;
                for (String aValue : values = stringValue.split(FXMLLoader.ARRAY_COMPONENT_DELIMITER)) {
                    aValue = aValue.trim();
                    list.add(BeanAdapter.coerce(this.resolvePrefixedValue(aValue), itemType));
                }
            }
        }

        public void warnDeprecatedEscapeSequence(String prefix) {
            System.err.println(prefix + prefix + " is a deprecated escape sequence. Please use \\" + prefix + " instead.");
        }

        public void applyProperty(String name, Class<?> sourceType, Object value) {
            if (sourceType == null) {
                this.getProperties().put(name, value);
            } else {
                BeanAdapter.put(this.value, sourceType, name, value);
            }
        }

        private Object getExpressionObject(String handlerValue) throws LoadException {
            if (handlerValue.startsWith(FXMLLoader.EXPRESSION_PREFIX)) {
                if ((handlerValue = handlerValue.substring(FXMLLoader.EXPRESSION_PREFIX.length())).length() == 0) {
                    throw FXMLLoader.this.constructLoadException("Missing expression reference.");
                }
                Object expression = Expression.get(FXMLLoader.this.namespace, KeyPath.parse(handlerValue));
                if (expression == null) {
                    throw FXMLLoader.this.constructLoadException("Unable to resolve expression : $" + handlerValue);
                }
                return expression;
            }
            return null;
        }

        private <T> T getExpressionObjectOfType(String handlerValue, Class<T> type) throws LoadException {
            Object expression = this.getExpressionObject(handlerValue);
            if (expression != null) {
                if (type.isInstance(expression)) {
                    return (T)expression;
                }
                throw FXMLLoader.this.constructLoadException("Error resolving \"" + handlerValue + "\" expression.Does not point to a " + type.getName());
            }
            return null;
        }

        private MethodHandler getControllerMethodHandle(String handlerName, SupportedType ... types) throws LoadException {
            if (handlerName.startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX) && !(handlerName = handlerName.substring(FXMLLoader.CONTROLLER_METHOD_PREFIX.length())).startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX)) {
                if (handlerName.length() == 0) {
                    throw FXMLLoader.this.constructLoadException("Missing controller method.");
                }
                if (FXMLLoader.this.controller == null) {
                    throw FXMLLoader.this.constructLoadException("No controller specified.");
                }
                for (SupportedType t : types) {
                    Method method = FXMLLoader.this.controllerAccessor.getControllerMethods().get((Object)t).get(handlerName);
                    if (method == null) continue;
                    return new MethodHandler(FXMLLoader.this.controller, method, t);
                }
                Method method = FXMLLoader.this.controllerAccessor.getControllerMethods().get((Object)SupportedType.PARAMETERLESS).get(handlerName);
                if (method != null) {
                    return new MethodHandler(FXMLLoader.this.controller, method, SupportedType.PARAMETERLESS);
                }
                return null;
            }
            return null;
        }

        public void processEventHandlerAttributes() throws LoadException {
            if (this.eventHandlerAttributes.size() > 0 && !FXMLLoader.this.staticLoad) {
                for (Attribute attribute : this.eventHandlerAttributes) {
                    String handlerName = attribute.value;
                    if (this.value instanceof ObservableList && attribute.name.equals(FXMLLoader.COLLECTION_HANDLER_NAME)) {
                        this.processObservableListHandler(handlerName);
                        continue;
                    }
                    if (this.value instanceof ObservableMap && attribute.name.equals(FXMLLoader.COLLECTION_HANDLER_NAME)) {
                        this.processObservableMapHandler(handlerName);
                        continue;
                    }
                    if (this.value instanceof ObservableSet && attribute.name.equals(FXMLLoader.COLLECTION_HANDLER_NAME)) {
                        this.processObservableSetHandler(handlerName);
                        continue;
                    }
                    if (attribute.name.endsWith(FXMLLoader.CHANGE_EVENT_HANDLER_SUFFIX)) {
                        this.processPropertyHandler(attribute.name, handlerName);
                        continue;
                    }
                    EventHandler eventHandler = null;
                    MethodHandler handler = this.getControllerMethodHandle(handlerName, SupportedType.EVENT);
                    if (handler != null) {
                        eventHandler = new ControllerMethodEventHandler(handler);
                    }
                    if (eventHandler == null) {
                        eventHandler = this.getExpressionObjectOfType(handlerName, EventHandler.class);
                    }
                    if (eventHandler == null) {
                        if (handlerName.length() == 0 || FXMLLoader.this.scriptEngine == null) {
                            throw FXMLLoader.this.constructLoadException("Error resolving " + attribute.name + "='" + attribute.value + "', either the event handler is not in the Namespace or there is an error in the script.");
                        }
                        eventHandler = new ScriptEventHandler(handlerName, FXMLLoader.this.scriptEngine, FXMLLoader.this.location.getPath() + "-" + attribute.name + "_attribute_in_element_ending_at_line_" + FXMLLoader.this.getLineNumber());
                    }
                    this.getValueAdapter().put(attribute.name, (Object)eventHandler);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processObservableListHandler(String handlerValue) throws LoadException {
            ObservableList list = (ObservableList)this.value;
            if (handlerValue.startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX)) {
                MethodHandler handler = this.getControllerMethodHandle(handlerValue, SupportedType.LIST_CHANGE_LISTENER);
                if (handler == null) throw FXMLLoader.this.constructLoadException("Controller method \"" + handlerValue + "\" not found.");
                list.addListener((ListChangeListener)new ObservableListChangeAdapter(handler));
                return;
            } else {
                if (!handlerValue.startsWith(FXMLLoader.EXPRESSION_PREFIX)) return;
                Object listener = this.getExpressionObject(handlerValue);
                if (listener instanceof ListChangeListener) {
                    list.addListener((ListChangeListener)listener);
                    return;
                } else {
                    if (!(listener instanceof InvalidationListener)) throw FXMLLoader.this.constructLoadException("Error resolving \"" + handlerValue + "\" expression.Must be either ListChangeListener or InvalidationListener");
                    list.addListener((InvalidationListener)listener);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processObservableMapHandler(String handlerValue) throws LoadException {
            ObservableMap map = (ObservableMap)this.value;
            if (handlerValue.startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX)) {
                MethodHandler handler = this.getControllerMethodHandle(handlerValue, SupportedType.MAP_CHANGE_LISTENER);
                if (handler == null) throw FXMLLoader.this.constructLoadException("Controller method \"" + handlerValue + "\" not found.");
                map.addListener((MapChangeListener)new ObservableMapChangeAdapter(handler));
                return;
            } else {
                if (!handlerValue.startsWith(FXMLLoader.EXPRESSION_PREFIX)) return;
                Object listener = this.getExpressionObject(handlerValue);
                if (listener instanceof MapChangeListener) {
                    map.addListener((MapChangeListener)listener);
                    return;
                } else {
                    if (!(listener instanceof InvalidationListener)) throw FXMLLoader.this.constructLoadException("Error resolving \"" + handlerValue + "\" expression.Must be either MapChangeListener or InvalidationListener");
                    map.addListener((InvalidationListener)listener);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processObservableSetHandler(String handlerValue) throws LoadException {
            ObservableSet set = (ObservableSet)this.value;
            if (handlerValue.startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX)) {
                MethodHandler handler = this.getControllerMethodHandle(handlerValue, SupportedType.SET_CHANGE_LISTENER);
                if (handler == null) throw FXMLLoader.this.constructLoadException("Controller method \"" + handlerValue + "\" not found.");
                set.addListener((SetChangeListener)new ObservableSetChangeAdapter(handler));
                return;
            } else {
                if (!handlerValue.startsWith(FXMLLoader.EXPRESSION_PREFIX)) return;
                Object listener = this.getExpressionObject(handlerValue);
                if (listener instanceof SetChangeListener) {
                    set.addListener((SetChangeListener)listener);
                    return;
                } else {
                    if (!(listener instanceof InvalidationListener)) throw FXMLLoader.this.constructLoadException("Error resolving \"" + handlerValue + "\" expression.Must be either SetChangeListener or InvalidationListener");
                    set.addListener((InvalidationListener)listener);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processPropertyHandler(String attributeName, String handlerValue) throws LoadException {
            int j;
            int i = FXMLLoader.EVENT_HANDLER_PREFIX.length();
            if (i == (j = attributeName.length() - FXMLLoader.CHANGE_EVENT_HANDLER_SUFFIX.length())) return;
            String key = Character.toLowerCase(attributeName.charAt(i)) + attributeName.substring(i + 1, j);
            ObservableValue propertyModel = this.getValueAdapter().getPropertyModel(key);
            if (propertyModel == null) {
                throw FXMLLoader.this.constructLoadException(this.value.getClass().getName() + " does not define a property model for \"" + key + "\".");
            }
            if (handlerValue.startsWith(FXMLLoader.CONTROLLER_METHOD_PREFIX)) {
                final MethodHandler handler = this.getControllerMethodHandle(handlerValue, SupportedType.PROPERTY_CHANGE_LISTENER, SupportedType.EVENT);
                if (handler == null) throw FXMLLoader.this.constructLoadException("Controller method \"" + handlerValue + "\" not found.");
                if (handler.type == SupportedType.EVENT) {
                    propertyModel.addListener((ChangeListener)new ChangeListener<Object>(){

                        public void changed(ObservableValue<?> observable, Object oldValue, Object newValue) {
                            handler.invoke(new Event(Element.this.value, null, Event.ANY));
                        }
                    });
                    return;
                } else {
                    propertyModel.addListener((ChangeListener)new PropertyChangeAdapter(handler));
                }
                return;
            } else {
                if (!handlerValue.startsWith(FXMLLoader.EXPRESSION_PREFIX)) return;
                Object listener = this.getExpressionObject(handlerValue);
                if (listener instanceof ChangeListener) {
                    propertyModel.addListener((ChangeListener)listener);
                    return;
                } else {
                    if (!(listener instanceof InvalidationListener)) throw FXMLLoader.this.constructLoadException("Error resolving \"" + handlerValue + "\" expression.Must be either ChangeListener or InvalidationListener");
                    propertyModel.addListener((InvalidationListener)listener);
                }
            }
        }
    }

    private static enum SupportedType {
        PARAMETERLESS{

            @Override
            protected boolean methodIsOfType(Method m) {
                return m.getParameterTypes().length == 0;
            }
        }
        ,
        EVENT{

            @Override
            protected boolean methodIsOfType(Method m) {
                return m.getParameterTypes().length == 1 && Event.class.isAssignableFrom(m.getParameterTypes()[0]);
            }
        }
        ,
        LIST_CHANGE_LISTENER{

            @Override
            protected boolean methodIsOfType(Method m) {
                return m.getParameterTypes().length == 1 && m.getParameterTypes()[0].equals(ListChangeListener.Change.class);
            }
        }
        ,
        MAP_CHANGE_LISTENER{

            @Override
            protected boolean methodIsOfType(Method m) {
                return m.getParameterTypes().length == 1 && m.getParameterTypes()[0].equals(MapChangeListener.Change.class);
            }
        }
        ,
        SET_CHANGE_LISTENER{

            @Override
            protected boolean methodIsOfType(Method m) {
                return m.getParameterTypes().length == 1 && m.getParameterTypes()[0].equals(SetChangeListener.Change.class);
            }
        }
        ,
        PROPERTY_CHANGE_LISTENER{

            @Override
            protected boolean methodIsOfType(Method m) {
                return m.getParameterTypes().length == 3 && ObservableValue.class.isAssignableFrom(m.getParameterTypes()[0]) && m.getParameterTypes()[1].equals(m.getParameterTypes()[2]);
            }
        };


        protected abstract boolean methodIsOfType(Method var1);
    }

    private class PropertyElement
    extends Element {
        public final String name;
        public final Class<?> sourceType;
        public final boolean readOnly;

        public PropertyElement(String name, Class<?> sourceType) throws LoadException {
            if (this.parent == null) {
                throw FXMLLoader.this.constructLoadException("Invalid root element.");
            }
            if (this.parent.value == null) {
                throw FXMLLoader.this.constructLoadException("Parent element does not support property elements.");
            }
            this.name = name;
            this.sourceType = sourceType;
            if (sourceType == null) {
                if (name.startsWith(FXMLLoader.EVENT_HANDLER_PREFIX)) {
                    throw FXMLLoader.this.constructLoadException("\"" + name + "\" is not a valid element name.");
                }
                Map<String, Object> parentProperties = this.parent.getProperties();
                this.readOnly = this.parent.isTyped() ? this.parent.getValueAdapter().isReadOnly(name) : parentProperties.containsKey(name);
                if (this.readOnly) {
                    Object value = parentProperties.get(name);
                    if (value == null) {
                        throw FXMLLoader.this.constructLoadException("Invalid property.");
                    }
                    this.updateValue(value);
                }
            } else {
                this.readOnly = false;
            }
        }

        @Override
        public boolean isCollection() {
            return this.readOnly ? super.isCollection() : false;
        }

        @Override
        public void add(Object element) throws LoadException {
            if (this.parent.isTyped()) {
                Type listType = this.parent.getValueAdapter().getGenericType(this.name);
                element = BeanAdapter.coerce(element, BeanAdapter.getListItemType(listType));
            }
            super.add(element);
        }

        @Override
        public void set(Object value) throws LoadException {
            this.updateValue(value);
            if (this.sourceType == null) {
                this.parent.getProperties().put(this.name, value);
            } else if (this.parent.value instanceof Builder) {
                this.parent.staticPropertyElements.add(this);
            } else {
                BeanAdapter.put(this.parent.value, this.sourceType, this.name, value);
            }
        }

        @Override
        public void processAttribute(String prefix, String localName, String value) throws IOException {
            if (!this.readOnly) {
                throw FXMLLoader.this.constructLoadException("Attributes are not supported for writable property elements.");
            }
            super.processAttribute(prefix, localName, value);
        }

        @Override
        public void processEndElement() throws IOException {
            super.processEndElement();
            if (this.readOnly) {
                this.processInstancePropertyAttributes();
                this.processEventHandlerAttributes();
            }
        }

        @Override
        public void processCharacters() throws IOException {
            String text = FXMLLoader.this.xmlStreamReader.getText();
            text = extraneousWhitespacePattern.matcher(text).replaceAll(" ").trim();
            if (this.readOnly) {
                if (this.isCollection()) {
                    this.add(text);
                } else {
                    super.processCharacters();
                }
            } else {
                this.set(text);
            }
        }
    }

    private class UnknownStaticPropertyElement
    extends Element {
        public UnknownStaticPropertyElement() throws LoadException {
            if (this.parent == null) {
                throw FXMLLoader.this.constructLoadException("Invalid root element.");
            }
            if (this.parent.value == null) {
                throw FXMLLoader.this.constructLoadException("Parent element does not support property elements.");
            }
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public void set(Object value) {
            this.updateValue(value);
        }

        @Override
        public void processCharacters() throws IOException {
            String text = FXMLLoader.this.xmlStreamReader.getText();
            text = extraneousWhitespacePattern.matcher(text).replaceAll(" ");
            this.updateValue(text.trim());
        }
    }

    private class InstanceDeclarationElement
    extends ValueElement {
        public Class<?> type;
        public String constant;
        public String factory;

        public InstanceDeclarationElement(Class<?> type) throws LoadException {
            this.constant = null;
            this.factory = null;
            this.type = type;
        }

        @Override
        public void processAttribute(String prefix, String localName, String value) throws IOException {
            if (prefix != null && prefix.equals(FXMLLoader.FX_NAMESPACE_PREFIX)) {
                if (localName.equals(FXMLLoader.FX_VALUE_ATTRIBUTE)) {
                    this.value = value;
                } else if (localName.equals(FXMLLoader.FX_CONSTANT_ATTRIBUTE)) {
                    this.constant = value;
                } else if (localName.equals(FXMLLoader.FX_FACTORY_ATTRIBUTE)) {
                    this.factory = value;
                } else {
                    super.processAttribute(prefix, localName, value);
                }
            } else {
                super.processAttribute(prefix, localName, value);
            }
        }

        @Override
        public Object constructValue() throws IOException {
            Object value;
            if (this.value != null) {
                value = BeanAdapter.coerce(this.value, this.type);
            } else if (this.constant != null) {
                value = BeanAdapter.getConstantValue(this.type, this.constant);
            } else {
                if (this.factory != null) {
                    Method factoryMethod;
                    try {
                        factoryMethod = MethodUtil.getMethod(this.type, (String)this.factory, (Class[])new Class[0]);
                    }
                    catch (NoSuchMethodException exception) {
                        throw FXMLLoader.this.constructLoadException(exception);
                    }
                    try {
                        value = MethodHelper.invoke(factoryMethod, null, new Object[0]);
                    }
                    catch (IllegalAccessException exception) {
                        throw FXMLLoader.this.constructLoadException(exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw FXMLLoader.this.constructLoadException(exception);
                    }
                }
                Object object = value = FXMLLoader.this.builderFactory == null ? null : FXMLLoader.this.builderFactory.getBuilder(this.type);
                if (value == null) {
                    value = DEFAULT_BUILDER_FACTORY.getBuilder(this.type);
                }
                if (value == null) {
                    try {
                        ReflectUtil.checkPackageAccess(this.type);
                        value = this.type.newInstance();
                    }
                    catch (InstantiationException exception) {
                        throw FXMLLoader.this.constructLoadException(exception);
                    }
                    catch (IllegalAccessException exception) {
                        throw FXMLLoader.this.constructLoadException(exception);
                    }
                }
            }
            return value;
        }
    }

    private class UnknownTypeElement
    extends ValueElement {
        private UnknownTypeElement() {
        }

        @Override
        public void processEndElement() throws IOException {
        }

        @Override
        public Object constructValue() throws LoadException {
            return new UnknownValueMap();
        }

        @DefaultProperty(value="items")
        public class UnknownValueMap
        extends AbstractMap<String, Object> {
            private ArrayList<?> items = new ArrayList();
            private HashMap<String, Object> values = new HashMap();

            @Override
            public Object get(Object key) {
                if (key == null) {
                    throw new NullPointerException();
                }
                return key.equals(this.getClass().getAnnotation(DefaultProperty.class).value()) ? this.items : this.values.get(key);
            }

            @Override
            public Object put(String key, Object value) {
                if (key == null) {
                    throw new NullPointerException();
                }
                if (key.equals(this.getClass().getAnnotation(DefaultProperty.class).value())) {
                    throw new IllegalArgumentException();
                }
                return this.values.put(key, value);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return Collections.emptySet();
            }
        }
    }

    private class IncludeElement
    extends ValueElement {
        public String source;
        public ResourceBundle resources;
        public Charset charset;

        private IncludeElement() {
            this.source = null;
            this.resources = FXMLLoader.this.resources;
            this.charset = FXMLLoader.this.charset;
        }

        @Override
        public void processAttribute(String prefix, String localName, String value) throws IOException {
            if (prefix == null) {
                if (localName.equals("source")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(localName, value);
                    }
                    this.source = value;
                } else if (localName.equals("resources")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(localName, value);
                    }
                    this.resources = ResourceBundle.getBundle(value, Locale.getDefault(), FXMLLoader.this.resources.getClass().getClassLoader());
                } else if (localName.equals("charset")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(localName, value);
                    }
                    this.charset = Charset.forName(value);
                } else {
                    super.processAttribute(prefix, localName, value);
                }
            } else {
                super.processAttribute(prefix, localName, value);
            }
        }

        @Override
        public Object constructValue() throws IOException {
            URL location;
            if (this.source == null) {
                throw FXMLLoader.this.constructLoadException("source is required.");
            }
            ClassLoader cl = FXMLLoader.this.getClassLoader();
            if (this.source.charAt(0) == '/') {
                location = cl.getResource(this.source.substring(1));
                if (location == null) {
                    throw FXMLLoader.this.constructLoadException("Cannot resolve path: " + this.source);
                }
            } else {
                if (FXMLLoader.this.location == null) {
                    throw FXMLLoader.this.constructLoadException("Base location is undefined.");
                }
                location = new URL(FXMLLoader.this.location, this.source);
            }
            FXMLLoader fxmlLoader = new FXMLLoader(location, this.resources, FXMLLoader.this.builderFactory, FXMLLoader.this.controllerFactory, this.charset, FXMLLoader.this.loaders);
            fxmlLoader.parentLoader = FXMLLoader.this;
            if (FXMLLoader.this.isCyclic(FXMLLoader.this, fxmlLoader)) {
                throw new IOException(String.format("Including \"%s\" in \"%s\" created cyclic reference.", fxmlLoader.location.toExternalForm(), FXMLLoader.this.location.toExternalForm()));
            }
            fxmlLoader.setClassLoader(cl);
            fxmlLoader.setStaticLoad(FXMLLoader.this.staticLoad);
            Object value = fxmlLoader.loadImpl(FXMLLoader.this.callerClass);
            if (this.fx_id != null) {
                String id = this.fx_id + FXMLLoader.CONTROLLER_SUFFIX;
                Object controller = fxmlLoader.getController();
                FXMLLoader.this.namespace.put((Object)id, controller);
                FXMLLoader.this.injectFields(id, controller);
            }
            return value;
        }
    }

    private class ReferenceElement
    extends ValueElement {
        public String source;

        private ReferenceElement() {
            this.source = null;
        }

        @Override
        public void processAttribute(String prefix, String localName, String value) throws IOException {
            if (prefix == null) {
                if (localName.equals("source")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(localName, value);
                    }
                    this.source = value;
                } else {
                    super.processAttribute(prefix, localName, value);
                }
            } else {
                super.processAttribute(prefix, localName, value);
            }
        }

        @Override
        public Object constructValue() throws LoadException {
            if (this.source == null) {
                throw FXMLLoader.this.constructLoadException("source is required.");
            }
            KeyPath path = KeyPath.parse(this.source);
            if (!Expression.isDefined(FXMLLoader.this.namespace, path)) {
                throw FXMLLoader.this.constructLoadException("Value \"" + this.source + "\" does not exist.");
            }
            return Expression.get(FXMLLoader.this.namespace, path);
        }
    }

    private class CopyElement
    extends ValueElement {
        public String source;

        private CopyElement() {
            this.source = null;
        }

        @Override
        public void processAttribute(String prefix, String localName, String value) throws IOException {
            if (prefix == null) {
                if (localName.equals("source")) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(localName, value);
                    }
                    this.source = value;
                } else {
                    super.processAttribute(prefix, localName, value);
                }
            } else {
                super.processAttribute(prefix, localName, value);
            }
        }

        @Override
        public Object constructValue() throws LoadException {
            Object value;
            if (this.source == null) {
                throw FXMLLoader.this.constructLoadException("source is required.");
            }
            KeyPath path = KeyPath.parse(this.source);
            if (!Expression.isDefined(FXMLLoader.this.namespace, path)) {
                throw FXMLLoader.this.constructLoadException("Value \"" + this.source + "\" does not exist.");
            }
            Object sourceValue = Expression.get(FXMLLoader.this.namespace, path);
            Class<?> sourceValueType = sourceValue.getClass();
            Constructor constructor = null;
            try {
                constructor = ConstructorUtil.getConstructor(sourceValueType, (Class[])new Class[]{sourceValueType});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (constructor != null) {
                try {
                    ReflectUtil.checkPackageAccess(sourceValueType);
                    value = constructor.newInstance(sourceValue);
                }
                catch (InstantiationException exception) {
                    throw FXMLLoader.this.constructLoadException(exception);
                }
                catch (IllegalAccessException exception) {
                    throw FXMLLoader.this.constructLoadException(exception);
                }
                catch (InvocationTargetException exception) {
                    throw FXMLLoader.this.constructLoadException(exception);
                }
            } else {
                throw FXMLLoader.this.constructLoadException("Can't copy value " + sourceValue + ".");
            }
            return value;
        }
    }

    private class RootElement
    extends ValueElement {
        public String type;

        private RootElement() {
            this.type = null;
        }

        @Override
        public void processAttribute(String prefix, String localName, String value) throws IOException {
            if (prefix == null) {
                if (localName.equals(FXMLLoader.ROOT_TYPE_ATTRIBUTE)) {
                    if (FXMLLoader.this.loadListener != null) {
                        FXMLLoader.this.loadListener.readInternalAttribute(localName, value);
                    }
                    this.type = value;
                } else {
                    super.processAttribute(prefix, localName, value);
                }
            } else {
                super.processAttribute(prefix, localName, value);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object constructValue() throws LoadException {
            Object value;
            if (this.type == null) {
                throw FXMLLoader.this.constructLoadException("type is required.");
            }
            Class<?> type = FXMLLoader.this.getType(this.type);
            if (type == null) {
                throw FXMLLoader.this.constructLoadException(this.type + " is not a valid type.");
            }
            if (FXMLLoader.this.root == null) {
                if (!FXMLLoader.this.staticLoad) throw FXMLLoader.this.constructLoadException("Root hasn't been set. Use method setRoot() before load.");
                Object object = value = FXMLLoader.this.builderFactory == null ? null : FXMLLoader.this.builderFactory.getBuilder(type);
                if (value == null) {
                    value = DEFAULT_BUILDER_FACTORY.getBuilder(type);
                }
                if (value == null) {
                    try {
                        ReflectUtil.checkPackageAccess(type);
                        value = type.newInstance();
                    }
                    catch (InstantiationException exception) {
                        throw FXMLLoader.this.constructLoadException(exception);
                    }
                    catch (IllegalAccessException exception) {
                        throw FXMLLoader.this.constructLoadException(exception);
                    }
                }
            } else {
                if (type.isAssignableFrom(FXMLLoader.this.root.getClass())) return FXMLLoader.this.root;
                throw FXMLLoader.this.constructLoadException("Root is not an instance of " + type.getName() + ".");
            }
            FXMLLoader.this.root = value;
            return value;
        }
    }

    private class ScriptElement
    extends Element {
        public String source = null;
        public Charset charset;

        private ScriptElement() {
            this.charset = FXMLLoader.this.charset;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processStartElement() throws IOException {
            block29: {
                super.processStartElement();
                if (this.source != null && !FXMLLoader.this.staticLoad) {
                    ScriptEngine engine;
                    int i = this.source.lastIndexOf(".");
                    if (i == -1) {
                        throw FXMLLoader.this.constructLoadException("Cannot determine type of script \"" + this.source + "\".");
                    }
                    String extension = this.source.substring(i + 1);
                    ClassLoader cl = FXMLLoader.this.getClassLoader();
                    if (FXMLLoader.this.scriptEngine != null && FXMLLoader.this.scriptEngine.getFactory().getExtensions().contains(extension)) {
                        engine = FXMLLoader.this.scriptEngine;
                    } else {
                        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(cl);
                            ScriptEngineManager scriptEngineManager = FXMLLoader.this.getScriptEngineManager();
                            engine = scriptEngineManager.getEngineByExtension(extension);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(oldLoader);
                        }
                    }
                    if (engine == null) {
                        throw FXMLLoader.this.constructLoadException("Unable to locate scripting engine for extension " + extension + ".");
                    }
                    try {
                        URL location;
                        if (this.source.charAt(0) == '/') {
                            location = cl.getResource(this.source.substring(1));
                        } else {
                            if (FXMLLoader.this.location == null) {
                                throw FXMLLoader.this.constructLoadException("Base location is undefined.");
                            }
                            location = new URL(FXMLLoader.this.location, this.source);
                        }
                        Bindings engineBindings = engine.getBindings(100);
                        String filename = location.getPath();
                        engineBindings.put("javax.script.filename", (Object)filename);
                        String script = null;
                        try (InputStreamReader scriptReader = null;){
                            int n;
                            scriptReader = new InputStreamReader(location.openStream(), this.charset);
                            StringBuilder sb = new StringBuilder();
                            int bufSize = 4096;
                            char[] charBuffer = new char[4096];
                            do {
                                if ((n = scriptReader.read(charBuffer, 0, 4096)) <= 0) continue;
                                sb.append(new String(charBuffer, 0, n));
                            } while (n > -1);
                            script = sb.toString();
                        }
                        try {
                            if (engine instanceof Compilable && compileScript) {
                                CompiledScript compiledScript = null;
                                try {
                                    compiledScript = ((Compilable)((Object)engine)).compile(script);
                                }
                                catch (ScriptException compileExc) {
                                    Logging.getJavaFXLogger().warning(filename + ": compiling caused \"" + compileExc + "\", falling back to evaluating script in uncompiled mode");
                                }
                                if (compiledScript != null) {
                                    compiledScript.eval();
                                } else {
                                    engine.eval(script);
                                }
                                break block29;
                            }
                            engine.eval(script);
                        }
                        catch (ScriptException exception) {
                            System.err.println(filename + ": caused ScriptException");
                            exception.printStackTrace();
                        }
                    }
                    catch (IOException exception) {
                        throw FXMLLoader.this.constructLoadException(exception);
                    }
                }
            }
        }

        @Override
        public void processEndElement() throws IOException {
            block8: {
                super.processEndElement();
                if (this.value != null && !FXMLLoader.this.staticLoad) {
                    String filename = null;
                    try {
                        Bindings engineBindings = FXMLLoader.this.scriptEngine.getBindings(100);
                        String script = (String)this.value;
                        filename = FXMLLoader.this.location.getPath() + "-script_starting_at_line_" + (FXMLLoader.this.getLineNumber() - (int)script.codePoints().filter(c -> c == 10).count());
                        ScriptEngine cfr_ignored_0 = FXMLLoader.this.scriptEngine;
                        engineBindings.put("javax.script.filename", (Object)filename);
                        if (FXMLLoader.this.scriptEngine instanceof Compilable && compileScript) {
                            CompiledScript compiledScript = null;
                            try {
                                compiledScript = ((Compilable)((Object)FXMLLoader.this.scriptEngine)).compile(script);
                            }
                            catch (ScriptException compileExc) {
                                Logging.getJavaFXLogger().warning(filename + ": compiling caused \"" + compileExc + "\", falling back to evaluating script in uncompiled mode");
                            }
                            if (compiledScript != null) {
                                compiledScript.eval();
                            } else {
                                FXMLLoader.this.scriptEngine.eval(script);
                            }
                            break block8;
                        }
                        FXMLLoader.this.scriptEngine.eval(script);
                    }
                    catch (ScriptException exception) {
                        System.err.println(filename + ": caused ScriptException\n" + exception.getMessage());
                    }
                }
            }
        }

        @Override
        public void processCharacters() throws LoadException {
            if (this.source != null) {
                throw FXMLLoader.this.constructLoadException("Script source already specified.");
            }
            if (FXMLLoader.this.scriptEngine == null && !FXMLLoader.this.staticLoad) {
                throw FXMLLoader.this.constructLoadException("Page language not specified.");
            }
            this.updateValue(FXMLLoader.this.xmlStreamReader.getText());
        }

        @Override
        public void processAttribute(String prefix, String localName, String value) throws IOException {
            if (prefix == null && localName.equals("source")) {
                if (FXMLLoader.this.loadListener != null) {
                    FXMLLoader.this.loadListener.readInternalAttribute(localName, value);
                }
                this.source = value;
            } else if (localName.equals("charset")) {
                if (FXMLLoader.this.loadListener != null) {
                    FXMLLoader.this.loadListener.readInternalAttribute(localName, value);
                }
                this.charset = Charset.forName(value);
            } else {
                throw FXMLLoader.this.constructLoadException((String)(prefix == null ? localName : prefix + ":" + localName + " is not a valid attribute."));
            }
        }
    }

    private class DefineElement
    extends Element {
        private DefineElement() {
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public void add(Object element) {
        }

        @Override
        public void processAttribute(String prefix, String localName, String value) throws LoadException {
            throw FXMLLoader.this.constructLoadException("Element does not support attributes.");
        }
    }

    private static class MethodHandler {
        private final Object controller;
        private final Method method;
        private final SupportedType type;

        private MethodHandler(Object controller, Method method, SupportedType type) {
            this.method = method;
            this.controller = controller;
            this.type = type;
        }

        public void invoke(Object ... params) {
            try {
                if (this.type != SupportedType.PARAMETERLESS) {
                    MethodHelper.invoke(this.method, this.controller, params);
                } else {
                    MethodHelper.invoke(this.method, this.controller, new Object[0]);
                }
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static class PropertyChangeAdapter
    implements ChangeListener<Object> {
        public final MethodHandler handler;

        public PropertyChangeAdapter(MethodHandler handler) {
            this.handler = handler;
        }

        public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
            this.handler.invoke(observable, oldValue, newValue);
        }
    }

    private static class ObservableSetChangeAdapter
    implements SetChangeListener {
        public final MethodHandler handler;

        public ObservableSetChangeAdapter(MethodHandler handler) {
            this.handler = handler;
        }

        public void onChanged(SetChangeListener.Change change) {
            if (this.handler != null) {
                this.handler.invoke(change);
            }
        }
    }

    private static class ObservableMapChangeAdapter
    implements MapChangeListener {
        public final MethodHandler handler;

        public ObservableMapChangeAdapter(MethodHandler handler) {
            this.handler = handler;
        }

        public void onChanged(MapChangeListener.Change change) {
            if (this.handler != null) {
                this.handler.invoke(change);
            }
        }
    }

    private static class ObservableListChangeAdapter
    implements ListChangeListener {
        private final MethodHandler handler;

        public ObservableListChangeAdapter(MethodHandler handler) {
            this.handler = handler;
        }

        public void onChanged(ListChangeListener.Change change) {
            if (this.handler != null) {
                this.handler.invoke(change);
            }
        }
    }

    private static class ScriptEventHandler
    implements EventHandler<Event> {
        public final String script;
        public final ScriptEngine scriptEngine;
        public final String filename;
        public CompiledScript compiledScript;
        public boolean isCompiled = false;

        public ScriptEventHandler(String script, ScriptEngine scriptEngine, String filename) {
            this.script = script;
            this.scriptEngine = scriptEngine;
            this.filename = filename;
            if (scriptEngine instanceof Compilable && compileScript) {
                try {
                    scriptEngine.getBindings(100).put("javax.script.filename", (Object)filename);
                    this.compiledScript = ((Compilable)((Object)scriptEngine)).compile(script);
                    this.isCompiled = true;
                }
                catch (ScriptException compileExc) {
                    Logging.getJavaFXLogger().warning(filename + ": compiling caused \"" + compileExc + "\", falling back to evaluating script in uncompiled mode");
                }
            }
        }

        public void handle(Event event) {
            Bindings engineBindings = this.scriptEngine.getBindings(100);
            Bindings localBindings = this.scriptEngine.createBindings();
            localBindings.putAll(engineBindings);
            localBindings.put(FXMLLoader.EVENT_KEY, (Object)event);
            localBindings.put("javax.script.argv", (Object)new Object[]{event});
            localBindings.put("javax.script.filename", (Object)this.filename);
            try {
                if (this.isCompiled) {
                    this.compiledScript.eval(localBindings);
                } else {
                    this.scriptEngine.eval(this.script, localBindings);
                }
            }
            catch (ScriptException exception) {
                throw new RuntimeException(this.filename + ": caused ScriptException", exception);
            }
        }
    }

    private static class ControllerMethodEventHandler<T extends Event>
    implements EventHandler<T> {
        private final MethodHandler handler;

        public ControllerMethodEventHandler(MethodHandler handler) {
            this.handler = handler;
        }

        public void handle(T event) {
            this.handler.invoke(event);
        }
    }

    private static class Attribute {
        public final String name;
        public final Class<?> sourceType;
        public final String value;

        public Attribute(String name, Class<?> sourceType, String value) {
            this.name = name;
            this.sourceType = sourceType;
            this.value = value;
        }
    }

    private abstract class ValueElement
    extends Element {
        public String fx_id = null;

        private ValueElement() {
        }

        @Override
        public void processStartElement() throws IOException {
            super.processStartElement();
            this.updateValue(this.constructValue());
            if (this.value instanceof Builder) {
                this.processInstancePropertyAttributes();
            } else {
                this.processValue();
            }
        }

        @Override
        public void processEndElement() throws IOException {
            super.processEndElement();
            if (this.value instanceof Builder) {
                Builder builder = (Builder)this.value;
                this.updateValue(builder.build());
                this.processValue();
            } else {
                this.processInstancePropertyAttributes();
            }
            this.processEventHandlerAttributes();
            if (this.staticPropertyAttributes.size() > 0) {
                for (Attribute attribute : this.staticPropertyAttributes) {
                    this.processPropertyAttribute(attribute);
                }
            }
            if (this.staticPropertyElements.size() > 0) {
                for (PropertyElement element : this.staticPropertyElements) {
                    BeanAdapter.put(this.value, element.sourceType, element.name, element.value);
                }
            }
            if (this.parent != null) {
                if (this.parent.isCollection()) {
                    this.parent.add(this.value);
                } else {
                    this.parent.set(this.value);
                }
            }
        }

        private Object getListValue(Element parent, String listPropertyName, Object value) {
            Type listType;
            if (parent.isTyped() && (listType = parent.getValueAdapter().getGenericType(listPropertyName)) != null) {
                Type itemType = BeanAdapter.getGenericListItemType(listType);
                if (itemType instanceof ParameterizedType) {
                    itemType = ((ParameterizedType)itemType).getRawType();
                }
                value = BeanAdapter.coerce(value, (Class)itemType);
            }
            return value;
        }

        private void processValue() throws LoadException {
            if (this.parent == null) {
                String nsVersion;
                String fxVersion;
                FXMLLoader.this.root = this.value;
                String fxNSURI = FXMLLoader.this.xmlStreamReader.getNamespaceContext().getNamespaceURI(FXMLLoader.FX_NAMESPACE_PREFIX);
                if (fxNSURI != null && FXMLLoader.compareJFXVersions(FXMLLoader.FX_NAMESPACE_VERSION, fxVersion = fxNSURI.substring(fxNSURI.lastIndexOf("/") + 1)) < 0) {
                    throw FXMLLoader.this.constructLoadException("Loading FXML document of version " + fxVersion + " by JavaFX runtime supporting version 1");
                }
                String defaultNSURI = FXMLLoader.this.xmlStreamReader.getNamespaceContext().getNamespaceURI("");
                if (defaultNSURI != null && FXMLLoader.compareJFXVersions(JAVAFX_VERSION, nsVersion = defaultNSURI.substring(defaultNSURI.lastIndexOf("/") + 1)) < 0) {
                    Logging.getJavaFXLogger().warning("Loading FXML document with JavaFX API of version " + nsVersion + " by JavaFX runtime of version " + JAVAFX_VERSION);
                }
            }
            if (this.fx_id != null) {
                Map<String, Object> properties;
                FXMLLoader.this.namespace.put((Object)this.fx_id, this.value);
                IDProperty idProperty = this.value.getClass().getAnnotation(IDProperty.class);
                if (idProperty != null && (properties = this.getProperties()).get(idProperty.value()) == null) {
                    properties.put(idProperty.value(), this.fx_id);
                }
                FXMLLoader.this.injectFields(this.fx_id, this.value);
            }
        }

        @Override
        public void processCharacters() throws LoadException {
            Class<?> type = this.value.getClass();
            DefaultProperty defaultProperty = type.getAnnotation(DefaultProperty.class);
            if (defaultProperty != null) {
                String text = FXMLLoader.this.xmlStreamReader.getText();
                text = extraneousWhitespacePattern.matcher(text).replaceAll(" ");
                String defaultPropertyName = defaultProperty.value();
                BeanAdapter valueAdapter = this.getValueAdapter();
                if (valueAdapter.isReadOnly(defaultPropertyName) && List.class.isAssignableFrom(valueAdapter.getType(defaultPropertyName))) {
                    List list = (List)valueAdapter.get((Object)defaultPropertyName);
                    list.add(this.getListValue(this, defaultPropertyName, text));
                } else {
                    valueAdapter.put(defaultPropertyName, (Object)text.trim());
                }
            } else {
                throw FXMLLoader.this.constructLoadException(type.getName() + " does not have a default property.");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void processAttribute(String prefix, String localName, String value) throws IOException {
            if (prefix != null && prefix.equals(FXMLLoader.FX_NAMESPACE_PREFIX)) {
                Class<?> type;
                if (localName.equals(FXMLLoader.FX_ID_ATTRIBUTE)) {
                    if (value.equals(FXMLLoader.NULL_KEYWORD)) {
                        throw FXMLLoader.this.constructLoadException("Invalid identifier.");
                    }
                    int n = value.length();
                    for (int i = 0; i < n; ++i) {
                        if (Character.isJavaIdentifierPart(value.charAt(i))) continue;
                        throw FXMLLoader.this.constructLoadException("Invalid identifier.");
                    }
                    this.fx_id = value;
                    return;
                }
                if (!localName.equals("controller")) throw FXMLLoader.this.constructLoadException("Invalid attribute.");
                if (FXMLLoader.this.current.parent != null) {
                    throw FXMLLoader.this.constructLoadException("fx:controller can only be applied to root element.");
                }
                if (FXMLLoader.this.controller != null) {
                    throw FXMLLoader.this.constructLoadException("Controller value already specified.");
                }
                if (FXMLLoader.this.staticLoad) return;
                try {
                    type = FXMLLoader.this.getClassLoader().loadClass(value);
                }
                catch (ClassNotFoundException exception) {
                    throw FXMLLoader.this.constructLoadException(exception);
                }
                try {
                    if (FXMLLoader.this.controllerFactory == null) {
                        ReflectUtil.checkPackageAccess(type);
                        FXMLLoader.this.setController(type.newInstance());
                        return;
                    }
                    FXMLLoader.this.setController(FXMLLoader.this.controllerFactory.call(type));
                    return;
                }
                catch (InstantiationException exception) {
                    throw FXMLLoader.this.constructLoadException(exception);
                }
                catch (IllegalAccessException exception) {
                    throw FXMLLoader.this.constructLoadException(exception);
                }
            }
            super.processAttribute(prefix, localName, value);
        }

        public abstract Object constructValue() throws IOException;
    }
}

