/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client.artifactoryXrayResponse;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jfrog.build.client.artifactoryXrayResponse.ImpactedArtifact;

public class Issue
implements Serializable {
    private static final long serialVersionUID = -2567386345962539129L;
    private String severity;
    private String type;
    private String provider;
    private String created;
    private String summary;
    private String description;
    private String cve;
    @JsonProperty(value="impacted_artifacts")
    private List<ImpactedArtifact> impactedArtifacts = null;

    public Issue() {
    }

    public Issue(String severity, String type, String provider, String created, String summary, String description, List<ImpactedArtifact> impactedArtifacts, String cve) {
        this.severity = severity;
        this.type = type;
        this.provider = provider;
        this.created = created;
        this.summary = summary;
        this.description = description;
        this.impactedArtifacts = impactedArtifacts;
        this.cve = cve;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="impacted_artifacts")
    public List<ImpactedArtifact> getImpactedArtifacts() {
        return this.impactedArtifacts;
    }

    @JsonProperty(value="impacted_artifacts")
    public void setImpactedArtifacts(List<ImpactedArtifact> impactedArtifacts) {
        this.impactedArtifacts = impactedArtifacts;
    }

    public String getCve() {
        return this.cve;
    }

    public void setCve(String cve) {
        this.cve = cve;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public IssueType getIssueType() {
        if ("Security".equals(this.getType())) {
            return IssueType.SECURITY;
        }
        if ("License".equals(this.getType())) {
            return IssueType.LICENSE;
        }
        return null;
    }

    public static enum IssueType {
        SECURITY,
        LICENSE;

    }
}

