/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.PreemptiveHttpClientBuilder;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.util.URI;

public class ArtifactoryHttpClient
implements AutoCloseable {
    public static final ArtifactoryVersion UNKNOWN_PROPERTIES_TOLERANT_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.3");
    public static final ArtifactoryVersion NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.4");
    public static final ArtifactoryVersion STANDALONE_BUILD_RETENTION_SUPPORTED_ARTIFACTORY_VERSION = new ArtifactoryVersion("5.2.1");
    public static final ArtifactoryVersion MINIMAL_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.3");
    public static final String VERSION_INFO_URL = "/api/system/version";
    private static final int DEFAULT_CONNECTION_TIMEOUT_SECS = 300;
    public static final int DEFAULT_CONNECTION_RETRY = 3;
    private final Log log;
    private final String artifactoryUrl;
    private final String username;
    private final String password;
    private final String accessToken;
    private int connectionTimeout = 300;
    private int connectionRetries = 3;
    private ProxyConfiguration proxyConfiguration;
    private boolean insecureTls = false;
    private PreemptiveHttpClient deployClient;

    private ArtifactoryHttpClient(String artifactoryUrl, String username, String password, String accessToken, Log log) {
        this.artifactoryUrl = org.apache.commons.lang.StringUtils.stripEnd((String)artifactoryUrl, (String)"/");
        this.username = username;
        this.password = password;
        this.accessToken = accessToken;
        this.log = log;
    }

    public ArtifactoryHttpClient(String artifactoryUrl, String username, String password, Log log) {
        this(artifactoryUrl, username, password, "", log);
    }

    public ArtifactoryHttpClient(String artifactoryUrl, String accessToken, Log log) {
        this(artifactoryUrl, "", "", accessToken, log);
    }

    public static String encodeUrl(String unescaped) {
        byte[] rawData = URLCodec.encodeUrl((BitSet)URI.allowed_query, (byte[])StringUtils.getBytesUtf8((String)unescaped));
        return StringUtils.newStringUsAscii((byte[])rawData);
    }

    public void setProxyConfiguration(String host, int port) {
        this.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.proxyConfiguration = new ProxyConfiguration();
        this.proxyConfiguration.host = host;
        this.proxyConfiguration.port = port;
        this.proxyConfiguration.username = username;
        this.proxyConfiguration.password = password;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionRetries(int connectionRetries) {
        this.connectionRetries = connectionRetries;
    }

    public void setInsecureTls(boolean insecureTls) {
        this.insecureTls = insecureTls;
    }

    public int getConnectionRetries() {
        return this.connectionRetries;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    @Override
    public void close() {
        if (this.deployClient != null) {
            this.deployClient.close();
        }
    }

    public PreemptiveHttpClient getHttpClient() {
        return this.getHttpClient(this.connectionTimeout);
    }

    public PreemptiveHttpClient getHttpClient(int connectionTimeout) {
        if (this.deployClient == null) {
            PreemptiveHttpClientBuilder clientBuilder = new PreemptiveHttpClientBuilder().setConnectionRetries(this.connectionRetries).setInsecureTls(this.insecureTls).setTimeout(connectionTimeout).setLog(this.log);
            if (this.proxyConfiguration != null) {
                clientBuilder.setProxyConfiguration(this.proxyConfiguration);
            }
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.accessToken)) {
                clientBuilder.setAccessToken(this.accessToken);
            } else {
                clientBuilder.setUserName(this.username).setPassword(this.password);
            }
            this.deployClient = clientBuilder.build();
        }
        return this.deployClient;
    }

    /*
     * Exception decompiling
     */
    public ArtifactoryVersion getVersion() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JsonNode getJsonNode(InputStream content) throws IOException {
        JsonParser parser = this.createJsonParser(content);
        return (JsonNode)parser.readValueAsTree();
    }

    private CloseableHttpResponse executeGetRequest(String lastModifiedUrl) throws IOException {
        PreemptiveHttpClient client = this.getHttpClient();
        HttpGet httpGet = new HttpGet(lastModifiedUrl);
        return client.execute((HttpUriRequest)httpGet);
    }

    public JsonParser createJsonParser(InputStream in) throws IOException {
        JsonFactory jsonFactory = this.createJsonFactory();
        return jsonFactory.createParser(in);
    }

    public JsonParser createJsonParser(String content) throws IOException {
        JsonFactory jsonFactory = this.createJsonFactory();
        return jsonFactory.createParser(content);
    }

    public JsonFactory createJsonFactory() {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonFactory.setCodec((ObjectCodec)mapper);
        return jsonFactory;
    }

    public ArtifactoryUploadResponse upload(HttpPut httpPut, HttpEntity fileEntity) throws IOException {
        httpPut.setEntity(fileEntity);
        return this.execute(httpPut);
    }

    public ArtifactoryUploadResponse execute(HttpPut httpPut) throws IOException {
        ArtifactoryUploadResponse artifactoryResponse = new ArtifactoryUploadResponse();
        try (CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpPut);){
            artifactoryResponse.setStatusLine(response.getStatusLine());
            if (response.getEntity() == null || response.getEntity().getContent() == null) {
                ArtifactoryUploadResponse artifactoryUploadResponse = artifactoryResponse;
                return artifactoryUploadResponse;
            }
            try (InputStream in = response.getEntity().getContent();){
                String content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (org.apache.commons.lang.StringUtils.isEmpty((String)content)) {
                    ArtifactoryUploadResponse artifactoryUploadResponse = artifactoryResponse;
                    return artifactoryUploadResponse;
                }
                try {
                    JsonParser parser = this.createJsonParser(content);
                    artifactoryResponse = (ArtifactoryUploadResponse)parser.readValueAs(ArtifactoryUploadResponse.class);
                    artifactoryResponse.setStatusLine(response.getStatusLine());
                }
                catch (Exception e) {
                    this.log.info("Response received: \n\n" + content + "\n\n");
                    this.log.error("Failed while reading the response from: " + httpPut, (Throwable)e);
                }
            }
            ArtifactoryUploadResponse artifactoryUploadResponse = artifactoryResponse;
            return artifactoryUploadResponse;
        }
    }

    public String getMessageFromEntity(HttpEntity entity) throws IOException {
        String responseMessage = "";
        if (entity != null && org.apache.commons.lang.StringUtils.isNotBlank((String)(responseMessage = this.getResponseEntityContent(entity)))) {
            responseMessage = " Response message: " + responseMessage;
        }
        return responseMessage;
    }

    private String getResponseEntityContent(HttpEntity responseEntity) throws IOException {
        InputStream in = responseEntity.getContent();
        if (in != null) {
            return IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        return "";
    }
}

