/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

@XStreamAlias(value="vcs")
public class Vcs
implements Serializable {
    private String revision = "";
    private String branch = "";
    private String url = "";

    public Vcs() {
    }

    public Vcs(String vcsUrl, String vcsRevision) {
        this.setUrl(vcsUrl);
        this.setRevision(vcsRevision);
    }

    public Vcs(String vcsUrl, String vcsRevision, String branch) {
        this(vcsUrl, vcsRevision);
        this.branch = branch;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return "revision='" + this.revision + '\'' + ", branch='" + this.branch + '\'' + ", url='" + this.url + '\'';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vcs)) {
            return false;
        }
        Vcs that = (Vcs)o;
        return Objects.equals(this.revision, that.revision) && Objects.equals(this.branch, that.branch) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.revision, this.branch, this.url);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.getRevision()) && StringUtils.isEmpty((String)this.getBranch()) && StringUtils.isEmpty((String)this.getUrl());
    }
}

