/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AqlSearchResult {
    private List<SearchEntry> results = new ArrayList<SearchEntry>();

    public List<SearchEntry> getResults() {
        return this.results;
    }

    public void setResults(List<SearchEntry> results) {
        this.results = results;
    }

    public static class Property {
        private String key;
        private String value;

        @JsonProperty(value="key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="key")
        public String getkey() {
            return this.key;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="value")
        public String getValue() {
            return this.value;
        }
    }

    public static class SearchEntry {
        private String repo;
        private String path;
        private String name;
        private String actualSha1;
        private String actualMd5;
        private String[] virtualRepos = new String[0];
        private HashMap<String, String> properties = new HashMap();

        public void setRepo(String repo) {
            this.repo = repo;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="actual_sha1")
        public void setActualSha1(String actualSha1) {
            this.actualSha1 = actualSha1;
        }

        @JsonProperty(value="actual_md5")
        public void setActualMd5(String actualMd5) {
            this.actualMd5 = actualMd5;
        }

        @JsonProperty(value="virtual_repos")
        public void setVirtualRepos(String[] virtualRepos) {
            this.virtualRepos = virtualRepos;
        }

        @JsonProperty(value="properties")
        public void setProperties(List<Property> propertiesList) {
            for (Property property : propertiesList) {
                if (!StringUtils.isNotEmpty((String)property.key)) continue;
                this.properties.put(property.key, property.value);
            }
        }

        public String getRepo() {
            return this.repo;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        @JsonProperty(value="actual_sha1")
        public String getActualSha1() {
            return this.actualSha1;
        }

        @JsonProperty(value="actual_md5")
        public String getActualMd5() {
            return this.actualMd5;
        }

        @JsonProperty(value="virtual_repos")
        public String[] getVirtualRepos() {
            return this.virtualRepos;
        }

        @JsonProperty(value="properties")
        public Map<String, String> getProperties() {
            return this.properties;
        }

        public String getBuildName() {
            return this.properties.get("build.name");
        }

        public String getBuildNumber() {
            return this.properties.get("build.number");
        }
    }
}

