/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jeyzer.profile.JeyzerProfileUpdater;
import org.jeyzer.profile.error.InvalidPatternsException;
import org.jeyzer.profile.error.ProfileUpdaterInitException;

@Mojo(name="update-profile", defaultPhase=LifecyclePhase.PACKAGE)
public class JeyzerProfileUpdaterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/src/main/config/jeyzer/${project.name}/analysis/patterns.xml", property="sourcePatterns", required=true)
    private File sourcePatterns;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jeyzer/new_pattern_entries.xml", property="newPatternEntries", required=false)
    private File newPatternEntries;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jeyzer", property="targetPatternsDir", required=false)
    private File targetPatternsDir;
    @Parameter(defaultValue="${project.name}_profile", property="targetProfileName", required=false)
    private String targetPatternsName;

    public void execute() throws MojoExecutionException {
        boolean result;
        JeyzerProfileUpdater updater = new JeyzerProfileUpdater();
        if (this.targetPatternsDir.exists() && this.targetPatternsDir.isFile()) {
            throw new MojoExecutionException("Profile target directory is a file. Please check the profile updater parameters. Given directory path is : " + this.targetPatternsDir);
        }
        if (!this.targetPatternsDir.exists() && !(result = this.targetPatternsDir.mkdirs())) {
            throw new MojoExecutionException("Profile target directory creation failed. Given directory path is : " + this.targetPatternsDir);
        }
        File patternsTarget = new File(this.targetPatternsDir, this.targetPatternsName + ".xml");
        this.getLog().info((CharSequence)("Generating analysis patterns  : " + patternsTarget.getPath()));
        this.getLog().info((CharSequence)("  from source patterns        : " + this.sourcePatterns.getPath()));
        this.getLog().info((CharSequence)("  with pattern entries from   : " + this.newPatternEntries.getPath()));
        try {
            updater.execute(this.sourcePatterns, patternsTarget, this.newPatternEntries);
        }
        catch (InvalidPatternsException ex) {
            throw new MojoExecutionException(ex.toString());
        }
        catch (ProfileUpdaterInitException ex) {
            throw new MojoExecutionException(ex.toString());
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.toString());
        }
    }
}

