/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.gremlin.server.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.graphdb.tinkerpop.gremlin.server.auth.JanusGraphAbstractAuthenticator;
import org.mindrot.jbcrypt.BCrypt;

public class HMACAuthenticator
extends JanusGraphAbstractAuthenticator {
    public static final String CONFIG_HMAC_ALGO = "hmacAlgo";
    public static final String CONFIG_TOKEN_TIMEOUT = "tokenTimeout";
    public static final String CONFIG_HMAC_SECRET = "hmacSecret";
    private static final String AUTH_ERROR = "Username and/or password are incorrect";
    private static final String DEFAULT_HMAC_ALGO = "HmacSHA256";
    private static final char[] DEFAULT_HMAC_SECRET = "secret".toCharArray();
    private static final Long DEFAULT_HMAC_TOKEN_TIMEOUT = 3600000L;
    private char[] secret;
    private String hmacAlgo;
    private Long timeout;

    @Override
    public boolean requireAuthentication() {
        return true;
    }

    @Override
    public Authenticator.SaslNegotiator newSaslNegotiator(InetAddress remoteAddress) {
        throw new RuntimeException("HMACAuthenticator does not use SASL!");
    }

    public Authenticator.SaslNegotiator newSaslNegotiator() {
        throw new RuntimeException("HMACAuthenticator does not use SASL!");
    }

    @Override
    public void setup(Map<String, Object> config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"Credential configuration cannot be null");
        Preconditions.checkState((boolean)config.containsKey(CONFIG_HMAC_SECRET), (String)"Credential configuration missing the %s key", (Object)CONFIG_HMAC_SECRET);
        this.hmacAlgo = config.containsKey(CONFIG_HMAC_ALGO) ? config.get(CONFIG_HMAC_ALGO).toString() : DEFAULT_HMAC_ALGO;
        this.timeout = config.containsKey(CONFIG_TOKEN_TIMEOUT) ? Long.valueOf(((Number)config.get(CONFIG_TOKEN_TIMEOUT)).longValue()) : DEFAULT_HMAC_TOKEN_TIMEOUT;
        super.setup(config);
        this.secret = config.containsKey(CONFIG_HMAC_SECRET) ? config.get(CONFIG_HMAC_SECRET).toString().toCharArray() : DEFAULT_HMAC_SECRET;
    }

    public AuthenticatedUser authenticate(Map<String, String> credentials) throws AuthenticationException {
        if (credentials.get("GENERATE_TOKEN") != null) {
            credentials.put("TOKEN", this.getToken(credentials));
            return this.authenticateUser(credentials);
        }
        if (credentials.get("TOKEN") != null) {
            if (this.validateToken(credentials)) {
                Map<String, String> tokenMap = this.parseToken(credentials.get("TOKEN"));
                return new AuthenticatedUser(tokenMap.get("username"));
            }
            throw new AuthenticationException("Invalid token");
        }
        return this.authenticateUser(credentials);
    }

    private AuthenticatedUser authenticateUser(Map<String, String> credentials) throws AuthenticationException {
        Vertex v = this.findUser(credentials.get("username"));
        if (null == v || !BCrypt.checkpw((String)credentials.get("password"), (String)((String)v.value("password")))) {
            throw new AuthenticationException(AUTH_ERROR);
        }
        return new AuthenticatedUser(credentials.get("username"));
    }

    private boolean validateToken(Map<String, String> credentials) {
        String token = credentials.get("TOKEN");
        Map<String, String> tokenMap = this.parseToken(token);
        String username = tokenMap.get("username");
        String time = tokenMap.get("time");
        String password = (String)this.findUser(username).value("password");
        String salt = this.getBcryptSaltFromStoredPassword(password);
        String expected = this.generateToken(username, salt, time);
        Long timeLong = Long.parseLong(time);
        long currentTime = new Date().getTime();
        String base64Token = new String(Base64.getUrlEncoder().encode(token.getBytes()));
        if (timeLong + this.timeout < currentTime || expected.length() != base64Token.length()) {
            return false;
        }
        boolean isValid = true;
        for (int i = 0; i < expected.length(); ++i) {
            if (base64Token.charAt(i) == expected.charAt(i)) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    private Map<String, String> parseToken(String token) {
        String[] parts = token.split(":");
        return ImmutableMap.of((Object)"username", (Object)parts[0], (Object)"time", (Object)parts[1], (Object)"hmac", (Object)parts[2]);
    }

    private String generateToken(String username, String salt, String time) {
        try {
            CharBuffer secretAndSalt = CharBuffer.allocate(this.secret.length + salt.length() + 1);
            secretAndSalt.put(this.secret);
            secretAndSalt.put(":");
            secretAndSalt.put(salt);
            String tokenPrefix = username + ":" + time + ":";
            SecretKeySpec keySpec = new SecretKeySpec(this.toBytes(secretAndSalt.array()), this.hmacAlgo);
            Mac hmac = Mac.getInstance(this.hmacAlgo);
            hmac.init(keySpec);
            hmac.update(username.getBytes());
            hmac.update(time.getBytes());
            Base64.Encoder encoder = Base64.getUrlEncoder();
            byte[] hmacbytes = encoder.encode(hmac.doFinal());
            byte[] tokenbytes = tokenPrefix.getBytes();
            byte[] token = ByteBuffer.wrap(new byte[tokenbytes.length + hmacbytes.length]).put(tokenbytes).put(hmacbytes).array();
            return new String(encoder.encode(token));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getToken(Map<String, String> credentials) {
        String username = credentials.get("username");
        Vertex user = this.findUser(username);
        String password = (String)user.value("password");
        String salt = this.getBcryptSaltFromStoredPassword(password);
        String time = Long.toString(new Date().getTime());
        return this.generateToken(username, salt, time);
    }

    private String getBcryptSaltFromStoredPassword(String password) {
        int saltStart = StringUtils.ordinalIndexOf((CharSequence)password, (CharSequence)"$", (int)3);
        return password.substring(saltStart + 1, saltStart + 23);
    }

    private byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }
}

