/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.grpc.schema;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.util.List;
import org.janusgraph.graphdb.grpc.JanusGraphContextHandler;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelByNameRequest;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelByNameResponse;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelsRequest;
import org.janusgraph.graphdb.grpc.schema.GetEdgeLabelsResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexCompositeGraphIndexByNameRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexCompositeGraphIndexByNameResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexCompositeGraphIndicesRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexCompositeGraphIndicesResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelByNameRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelByNameResponse;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelsRequest;
import org.janusgraph.graphdb.grpc.schema.GetVertexLabelsResponse;
import org.janusgraph.graphdb.grpc.schema.SchemaManagerProvider;
import org.janusgraph.graphdb.grpc.schema.SchemaManagerServiceGrpc;
import org.janusgraph.graphdb.grpc.types.EdgeLabel;
import org.janusgraph.graphdb.grpc.types.JanusGraphContext;
import org.janusgraph.graphdb.grpc.types.VertexCompositeGraphIndex;
import org.janusgraph.graphdb.grpc.types.VertexLabel;

public class SchemaManagerImpl
extends SchemaManagerServiceGrpc.SchemaManagerServiceImplBase {
    private final JanusGraphContextHandler contextHandler;

    public SchemaManagerImpl(JanusGraphContextHandler contextHandler) {
        this.contextHandler = contextHandler;
    }

    private SchemaManagerProvider getSchemaManagerProvider(JanusGraphContext context, ErrorFunction errorFunction) {
        if (context == null) {
            errorFunction.run(Status.INVALID_ARGUMENT.withDescription("context is required").asException());
            return null;
        }
        SchemaManagerProvider provider = this.contextHandler.getSchemaManagerProviderByContext(context);
        if (provider == null) {
            errorFunction.run(Status.INVALID_ARGUMENT.withDescription("a schema manager provider was not found with the provided context").asException());
            return null;
        }
        return provider;
    }

    public void getVertexLabelByName(GetVertexLabelByNameRequest request, StreamObserver<GetVertexLabelByNameResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        String vertexLabelName = request.getName();
        if (vertexLabelName.isEmpty()) {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("name is required").asException());
            return;
        }
        try {
            VertexLabel vertexLabel = provider.getVertexLabelByName(vertexLabelName);
            responseObserver.onNext((Object)GetVertexLabelByNameResponse.newBuilder().setVertexLabel(vertexLabel).build());
            responseObserver.onCompleted();
        }
        catch (StatusException exception) {
            responseObserver.onError((Throwable)exception);
        }
        catch (Exception exception) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)exception).asException());
        }
    }

    public void getVertexLabels(GetVertexLabelsRequest request, StreamObserver<GetVertexLabelsResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        try {
            List<VertexLabel> vertexLabels = provider.getVertexLabels();
            responseObserver.onNext((Object)GetVertexLabelsResponse.newBuilder().addAllVertexLabels(vertexLabels).build());
            responseObserver.onCompleted();
        }
        catch (Exception exception) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)exception).asException());
        }
    }

    public void getEdgeLabelByName(GetEdgeLabelByNameRequest request, StreamObserver<GetEdgeLabelByNameResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        String edgeLabelName = request.getName();
        if (edgeLabelName.isEmpty()) {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("name is required").asException());
            return;
        }
        try {
            EdgeLabel edgeLabel = provider.getEdgeLabelByName(edgeLabelName);
            responseObserver.onNext((Object)GetEdgeLabelByNameResponse.newBuilder().setEdgeLabel(edgeLabel).build());
            responseObserver.onCompleted();
        }
        catch (StatusException exception) {
            responseObserver.onError((Throwable)exception);
        }
        catch (Exception exception) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)exception).asException());
        }
    }

    public void getEdgeLabels(GetEdgeLabelsRequest request, StreamObserver<GetEdgeLabelsResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        try {
            List<EdgeLabel> edgeLabels = provider.getEdgeLabels();
            responseObserver.onNext((Object)GetEdgeLabelsResponse.newBuilder().addAllEdgeLabels(edgeLabels).build());
            responseObserver.onCompleted();
        }
        catch (Exception exception) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)exception).asException());
        }
    }

    public void getVertexCompositeGraphIndexByName(GetVertexCompositeGraphIndexByNameRequest request, StreamObserver<GetVertexCompositeGraphIndexByNameResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        String indexName = request.getName();
        if (indexName.isEmpty()) {
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("name is required").asException());
            return;
        }
        try {
            VertexCompositeGraphIndex index = provider.getVertexCompositeGraphIndexByName(indexName);
            responseObserver.onNext((Object)GetVertexCompositeGraphIndexByNameResponse.newBuilder().setIndex(index).build());
            responseObserver.onCompleted();
        }
        catch (StatusException exception) {
            responseObserver.onError((Throwable)exception);
        }
        catch (Exception exception) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)exception).asException());
        }
    }

    public void getVertexCompositeGraphIndices(GetVertexCompositeGraphIndicesRequest request, StreamObserver<GetVertexCompositeGraphIndicesResponse> responseObserver) {
        SchemaManagerProvider provider = this.getSchemaManagerProvider(request.getContext(), arg_0 -> responseObserver.onError(arg_0));
        if (provider == null) {
            return;
        }
        try {
            List<VertexCompositeGraphIndex> indices = provider.getVertexCompositeGraphIndices();
            responseObserver.onNext((Object)GetVertexCompositeGraphIndicesResponse.newBuilder().addAllIndices(indices).build());
            responseObserver.onCompleted();
        }
        catch (Exception exception) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause((Throwable)exception).asException());
        }
    }

    static interface ErrorFunction {
        public void run(Throwable var1);
    }
}

