/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.gremlin.server.handler;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.server.handler.AbstractAuthenticationHandler;

public class HttpHMACAuthenticationHandler
extends AbstractAuthenticationHandler {
    private final Base64.Decoder decoder = Base64.getUrlDecoder();
    private final String basic = "Basic ";
    private final String token = "Token ";
    public static final String PROPERTY_TOKEN = "TOKEN";
    public static final String PROPERTY_GENERATE_TOKEN = "GENERATE_TOKEN";

    public HttpHMACAuthenticationHandler(Authenticator authenticator) {
        super(authenticator);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest req = (FullHttpRequest)msg;
            HttpMethod method = req.getMethod();
            Map<String, String> credentialsMap = this.getCredentialsMap(ctx, req);
            if (credentialsMap == null) {
                this.sendError(ctx, msg);
                return;
            }
            if ("/session".equals(req.getUri()) && method.equals((Object)HttpMethod.GET)) {
                try {
                    credentialsMap.put(PROPERTY_GENERATE_TOKEN, "true");
                    this.authenticator.authenticate(credentialsMap);
                }
                catch (Exception e) {
                    this.sendError(ctx, msg);
                    return;
                }
                this.replyWithToken(ctx, msg, credentialsMap.get(PROPERTY_TOKEN));
            } else {
                try {
                    this.authenticator.authenticate(credentialsMap);
                    ctx.fireChannelRead((Object)req);
                }
                catch (Exception e) {
                    this.sendError(ctx, msg);
                }
            }
        }
    }

    private Map<String, String> getCredentialsMap(ChannelHandlerContext ctx, FullHttpRequest req) {
        String authorizationHeader = req.headers().get("Authorization");
        if (authorizationHeader == null) {
            return null;
        }
        if (!authorizationHeader.startsWith("Basic ") && !authorizationHeader.startsWith("Token ")) {
            return null;
        }
        String authType = authorizationHeader.startsWith("Basic ") ? "Basic " : "Token ";
        return this.getAuthCredMap(authorizationHeader, authType);
    }

    private Map<String, String> getAuthCredMap(String authorizationHeader, String authType) {
        String authorization;
        try {
            String encodedAuthParams = authorizationHeader.substring(authType.length());
            byte[] decodedAuthParams = this.decoder.decode(encodedAuthParams);
            authorization = new String(decodedAuthParams);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            return null;
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        if (authType.equals("Basic ")) {
            String[] split = authorization.split(":");
            if (split.length != 2) {
                return null;
            }
            credentials.put("username", split[0]);
            credentials.put("password", split[1]);
        } else {
            credentials.put(PROPERTY_TOKEN, authorization);
        }
        return credentials;
    }

    private void sendError(ChannelHandlerContext ctx, Object msg) {
        ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        ReferenceCountUtil.release((Object)msg);
    }

    private void replyWithToken(ChannelHandlerContext ctx, Object msg, String token) {
        String json = "{\"token\": \"" + token + "\"}";
        byte[] jsonBytes = json.getBytes();
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])jsonBytes));
        response.headers().set("Content-Type", (Object)"application/json");
        response.headers().set("Content-Length", (Object)response.content().readableBytes());
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        ReferenceCountUtil.release((Object)msg);
    }
}

