// Copyright 2023 JanusGraph Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.janusgraph.diskstorage.cql;

import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.builder.CQLMutateManyFunctionBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLProgrammaticConfigurationLoaderBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLSessionBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLStoreFeaturesBuilder;

public class ScyllaStoreManager extends CQLStoreManager {

    public ScyllaStoreManager(Configuration configuration) throws BackendException {
        super(configuration);
    }

    public ScyllaStoreManager(Configuration configuration, CQLMutateManyFunctionBuilder mutateManyFunctionBuilder, CQLStoreFeaturesBuilder storeFeaturesBuilder, CQLSessionBuilder sessionBuilder, CQLProgrammaticConfigurationLoaderBuilder baseConfigurationLoaderBuilder) throws BackendException {
        super(configuration, mutateManyFunctionBuilder, storeFeaturesBuilder, sessionBuilder, baseConfigurationLoaderBuilder);
    }
}
