/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.lucene;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;

public class SumCollector
extends SimpleCollector {
    double sum = 0.0;
    final String fieldName;
    LeafReaderContext context;
    final IndexSearcher searcher;
    final Set<String> fieldSet;

    public SumCollector(String fieldName, IndexSearcher searcher) {
        this.fieldName = fieldName;
        this.searcher = searcher;
        this.fieldSet = Sets.newHashSet((Object[])new String[]{fieldName});
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.context = context;
    }

    public void setScorer(Scorable scorer) throws IOException {
    }

    public void collect(int doc) throws IOException {
        this.sum += this.searcher.doc(this.context.docBase + doc, this.fieldSet).getField(this.fieldName).numericValue().doubleValue();
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public double getValue() {
        return this.sum;
    }
}

