/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.hbase;

import org.janusgraph.HBaseContainer;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.KeyColumnValueStoreTest;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.hbase.HBaseStoreManager;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class HBaseStoreTest
extends KeyColumnValueStoreTest {
    @Container
    public static final HBaseContainer hBaseContainer = new HBaseContainer();

    public HBaseStoreManager openStorageManager(ModifiableConfiguration config) throws BackendException {
        return new HBaseStoreManager((Configuration)new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)config.getConfiguration(), BasicConfiguration.Restriction.NONE));
    }

    public HBaseStoreManager openStorageManager() throws BackendException {
        return this.openStorageManager("");
    }

    public HBaseStoreManager openStorageManager(String tableName) throws BackendException {
        return this.openStorageManager(tableName, "");
    }

    public HBaseStoreManager openStorageManager(String tableName, String graphName) throws BackendException {
        return new HBaseStoreManager((Configuration)hBaseContainer.getNamedConfiguration(tableName, graphName));
    }

    @Test
    public void testGetKeysWithKeyRange(TestInfo testInfo) throws Exception {
        super.testGetKeysWithKeyRange(testInfo);
    }

    public HBaseStoreManager openStorageManagerForClearStorageTest() throws Exception {
        return this.openStorageManager(hBaseContainer.getModifiableConfiguration().set(GraphDatabaseConfiguration.DROP_ON_CLEAR, (Object)true, new String[0]));
    }

    @Test
    public void tableShouldEqualSuppliedTableName() throws BackendException {
        HBaseStoreManager mgr = this.openStorageManager("randomTableName");
        Assertions.assertEquals((Object)"randomTableName", (Object)mgr.getName());
    }

    @Test
    public void tableShouldEqualGraphName() throws BackendException {
        HBaseStoreManager mgr = this.openStorageManager("", "randomGraphName");
        Assertions.assertEquals((Object)"randomGraphName", (Object)mgr.getName());
    }
}

