/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.hbase;

import com.google.common.collect.BiMap;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.hbase.HBaseStoreManager;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.formats.hbase.HBaseBinaryRecordReader;
import org.janusgraph.hadoop.formats.util.AbstractBinaryInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSnapshotBinaryInputFormat
extends AbstractBinaryInputFormat {
    private static final Logger log = LoggerFactory.getLogger(HBaseSnapshotBinaryInputFormat.class);
    private static final String SNAPSHOT_NAME_KEY = "hbase.TableSnapshotInputFormat.snapshot.name";
    private static final String RESTORE_DIR_KEY = "hbase.TableSnapshotInputFormat.restore.dir";
    private final TableSnapshotInputFormat tableSnapshotInputFormat = new TableSnapshotInputFormat();
    private RecordReader<ImmutableBytesWritable, Result> tableReader;
    private byte[] edgeStoreFamily;
    private RecordReader<StaticBuffer, Iterable<Entry>> janusgraphRecordReader;

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.tableSnapshotInputFormat.getSplits(jobContext);
    }

    public RecordReader<StaticBuffer, Iterable<Entry>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.tableReader = this.tableSnapshotInputFormat.createRecordReader(inputSplit, taskAttemptContext);
        this.janusgraphRecordReader = new HBaseBinaryRecordReader(this.tableReader, this.edgeStoreFamily);
        return this.janusgraphRecordReader;
    }

    public void setConf(org.apache.hadoop.conf.Configuration config) {
        HBaseConfiguration.addHbaseResources((org.apache.hadoop.conf.Configuration)config);
        super.setConf(config);
        Map configSub = this.janusgraphConf.getSubset(HBaseStoreManager.HBASE_CONFIGURATION_NAMESPACE, new String[0]);
        for (Map.Entry entry : configSub.entrySet()) {
            log.info("HBase configuration: setting {}={}", entry.getKey(), entry.getValue());
            if (entry.getValue() == null) continue;
            config.set((String)entry.getKey(), entry.getValue().toString());
        }
        config.set("autotype", "none");
        Scan scanner = new Scan();
        String cfName = (String)this.mrConf.get(JanusGraphHadoopConfiguration.COLUMN_FAMILY_NAME, new String[0]);
        if (((Boolean)this.janusgraphConf.get(HBaseStoreManager.SHORT_CF_NAMES, new String[0])).booleanValue()) {
            try {
                BiMap<String, String> shortCfMap = HBaseStoreManager.createShortCfMap((Configuration)this.janusgraphConf);
                cfName = HBaseStoreManager.shortenCfName(shortCfMap, cfName);
            }
            catch (PermanentBackendException e) {
                throw new RuntimeException(e);
            }
        }
        this.edgeStoreFamily = Bytes.toBytes((String)cfName);
        scanner.addFamily(this.edgeStoreFamily);
        try {
            Method converter = TableMapReduceUtil.class.getDeclaredMethod("convertScanToString", Scan.class);
            converter.setAccessible(true);
            config.set("hbase.mapreduce.scan", (String)converter.invoke(null, scanner));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String snapshotName = (String)this.janusgraphConf.get(HBaseStoreManager.HBASE_SNAPSHOT, new String[0]);
        String restoreDirString = (String)this.janusgraphConf.get(HBaseStoreManager.HBASE_SNAPSHOT_RESTORE_DIR, new String[0]);
        Path restoreDir = new Path(restoreDirString);
        try {
            Job job = Job.getInstance((org.apache.hadoop.conf.Configuration)config);
            TableSnapshotInputFormat.setInput((Job)job, (String)snapshotName, (Path)restoreDir);
            config.set(SNAPSHOT_NAME_KEY, job.getConfiguration().get(SNAPSHOT_NAME_KEY));
            config.set(RESTORE_DIR_KEY, job.getConfiguration().get(RESTORE_DIR_KEY));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public org.apache.hadoop.conf.Configuration getConf() {
        return super.getConf();
    }
}

