/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.scan;

import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;

public class HadoopContextScanMetrics
implements ScanMetrics {
    private final TaskInputOutputContext taskIOCtx;
    public static final String CUSTOM_COUNTER_GROUP = "ScanJob.Custom";
    public static final String STANDARD_COUNTER_GROUP = "ScanJob.Standard";

    public HadoopContextScanMetrics(TaskInputOutputContext taskIOCtx) {
        this.taskIOCtx = taskIOCtx;
    }

    public long getCustom(String metric) {
        return this.taskIOCtx.getCounter(CUSTOM_COUNTER_GROUP, metric).getValue();
    }

    public void incrementCustom(String metric, long delta) {
        this.taskIOCtx.getCounter(CUSTOM_COUNTER_GROUP, metric).increment(delta);
    }

    public void incrementCustom(String metric) {
        this.incrementCustom(metric, 1L);
    }

    public long get(ScanMetrics.Metric metric) {
        return this.taskIOCtx.getCounter(STANDARD_COUNTER_GROUP, metric.name()).getValue();
    }

    public void increment(ScanMetrics.Metric metric) {
        this.taskIOCtx.getCounter(STANDARD_COUNTER_GROUP, metric.name()).increment(1L);
    }
}

