/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.spark.process.computer.SparkGraphComputer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.testutil.TestGraphConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusGraphCustomIdSparkTest
extends JanusGraphBaseTest {
    private static final Logger log = LoggerFactory.getLogger(JanusGraphCustomIdSparkTest.class);

    public WriteConfiguration getConfiguration() {
        return this.getModifiableConfiguration().getConfiguration();
    }

    protected abstract ModifiableConfiguration getModifiableConfiguration();

    protected abstract Graph getSparkGraph() throws IOException, ConfigurationException;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testInfo = testInfo;
        this.config = this.getConfiguration();
        TestGraphConfigs.applyOverrides((WriteConfiguration)this.config);
        Preconditions.checkNotNull((Object)this.config);
        this.logManagers = new HashMap();
        JanusGraphCustomIdSparkTest.clearGraph((WriteConfiguration)this.config);
        this.readConfig = new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)this.config, BasicConfiguration.Restriction.NONE);
    }

    private void open(boolean allowSettingVertexId, boolean allowCustomVertexIdType) {
        ModifiableConfiguration config = this.getModifiableConfiguration();
        config.set(GraphDatabaseConfiguration.ALLOW_SETTING_VERTEX_ID, (Object)allowSettingVertexId, new String[0]);
        config.set(GraphDatabaseConfiguration.ALLOW_CUSTOM_VERTEX_ID_TYPES, (Object)allowCustomVertexIdType, new String[0]);
        this.open(config.getConfiguration());
    }

    @Test
    public void testUpgrade() throws Exception {
        this.open(true, false);
        int numV = 10;
        for (int i = 1; i <= numV; ++i) {
            this.graph.traversal().addV().property((Object)T.id, (Object)this.graph.getIDManager().toVertexId((long)i), new Object[0]).next();
        }
        this.graph.tx().commit();
        this.graph.close();
        this.open(true, true);
        JanusGraphManagement mgmt = this.graph.openManagement();
        mgmt.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_CUSTOM_VERTEX_ID_TYPES, (String[])new String[0]), (Object)true);
        mgmt.commit();
        this.open(true, true);
        GraphTraversalSource t = this.getSparkGraph().traversal().withComputer(SparkGraphComputer.class);
        Assertions.assertEquals((long)numV, (Long)((Long)t.V(new Object[0]).count().next()));
        for (int i = 1; i <= numV; ++i) {
            Vertex outV = (Vertex)this.graph.traversal().V(new Object[0]).hasId((Object)this.graph.getIDManager().toVertexId((long)i), new Object[0]).next();
            Vertex inV = (Vertex)this.graph.traversal().addV().property((Object)T.id, (Object)("STRING_ID_" + i), new Object[0]).next();
            this.graph.traversal().addE("links").from(outV).to(inV).next();
        }
        this.graph.tx().commit();
        Assertions.assertEquals((long)(2 * numV), (Long)((Long)t.V(new Object[0]).count().next()));
        Assertions.assertEquals((long)numV, (Long)((Long)t.E(new Object[0]).count().next()));
    }

    @Test
    public void testReadWideVertexWithManyProperties() throws Exception {
        int i;
        this.open(true, true);
        int numProps = 65536;
        long numV = 1L;
        this.mgmt.makePropertyKey("p").cardinality(Cardinality.LIST).dataType(Integer.class).make();
        this.mgmt.commit();
        this.finishSchema();
        int j = 0;
        while ((long)j < numV) {
            JanusGraphVertex v = this.graph.addVertex(new Object[]{T.id, UUID.randomUUID().toString().replace('-', ':')});
            for (i = 0; i < numProps; ++i) {
                v.property("p", (Object)i);
                if (i % 8 != 0) continue;
                this.graph.tx().commit();
            }
            ++j;
        }
        this.graph.tx().commit();
        Assertions.assertEquals((long)numV, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        Map propertiesOnVertex = (Map)this.graph.traversal().V(new Object[0]).valueMap(new String[0]).next();
        List valuesOnP = (List)propertiesOnVertex.values().iterator().next();
        Assertions.assertEquals((int)numProps, (int)valuesOnP.size());
        for (i = 0; i < numProps; ++i) {
            Assertions.assertEquals((Object)Integer.toString(i), (Object)valuesOnP.get(i).toString());
        }
        GraphTraversalSource t = this.getSparkGraph().traversal().withComputer(SparkGraphComputer.class);
        Assertions.assertEquals((long)numV, (long)((Long)t.V(new Object[0]).count().next()));
        propertiesOnVertex = (Map)t.V(new Object[0]).valueMap(new String[0]).next();
        Set observedValuesOnP = Collections.unmodifiableSet(new HashSet((List)propertiesOnVertex.values().iterator().next()));
        Assertions.assertEquals((int)numProps, (int)observedValuesOnP.size());
        Assertions.assertEquals(Collections.unmodifiableSet(new HashSet(valuesOnP)), observedValuesOnP, (String)"Unexpected values");
    }
}

