/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.config.job;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Arrays;
import org.janusgraph.graphdb.configuration.JanusGraphConstants;
import org.janusgraph.hadoop.DistCacheConfigurer;
import org.janusgraph.hadoop.MapredJarConfigurer;
import org.janusgraph.hadoop.config.job.JobClasspathConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClasspathConfigurers {
    private static final Logger log = LoggerFactory.getLogger(JobClasspathConfigurers.class);
    private static final ImmutableList<String> POSSIBLE_MAPRED_JAR_DIRS;

    public static JobClasspathConfigurer get(String configuredMapReduceJar, String defaultMapReduceJar) {
        if (null != configuredMapReduceJar) {
            log.info("Using configuration's mapred job jar: {}", (Object)configuredMapReduceJar);
            return new MapredJarConfigurer(configuredMapReduceJar);
        }
        for (String dir : POSSIBLE_MAPRED_JAR_DIRS) {
            String candidate = dir + File.separator + defaultMapReduceJar;
            if (!new File(candidate).exists()) continue;
            log.info("Using mapred job jar found in {}: {}", (Object)dir, (Object)candidate);
            return new MapredJarConfigurer(candidate);
        }
        log.info("Uploading jars on classpath DistributedCache in lieu of a mapred job jar");
        return new DistCacheConfigurer("janusgraph-hadoop-" + JanusGraphConstants.VERSION + ".jar");
    }

    static {
        ImmutableList.Builder b = ImmutableList.builder();
        for (String prefix : Arrays.asList("", ".." + File.separator)) {
            for (String dir : Arrays.asList("target", "lib")) {
                b.add((Object)(prefix + dir));
            }
        }
        POSSIBLE_MAPRED_JAR_DIRS = b.build();
    }
}

