/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import com.google.common.collect.Iterables;
import java.io.FileNotFoundException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.example.GraphOfTheGodsFactory;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.management.RelationIndexStatusWatcher;
import org.janusgraph.hadoop.MapReduceIndexManagement;
import org.janusgraph.hadoop.MapReduceRemoveIndexApp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractIndexManagementIT
extends JanusGraphBaseTest {
    private void prepareGraphIndex() throws InterruptedException {
        this.tx.commit();
        this.mgmt.commit();
        GraphOfTheGodsFactory.loadWithoutMixedIndex((JanusGraph)this.graph, (boolean)true);
        JanusGraphManagement m = this.graph.openManagement();
        JanusGraphIndex nameIndex = m.getGraphIndex("name");
        m.updateIndex((Index)nameIndex, SchemaAction.DISABLE_INDEX);
        m.commit();
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"name").status(new SchemaStatus[]{SchemaStatus.DISABLED})).call().getSucceeded());
    }

    @Test
    public void testRemoveGraphIndex() throws InterruptedException, BackendException, ExecutionException {
        this.prepareGraphIndex();
        MapReduceIndexManagement mri = new MapReduceIndexManagement((JanusGraph)this.graph);
        JanusGraphManagement m = this.graph.openManagement();
        JanusGraphIndex index = m.getGraphIndex("name");
        ScanMetrics metrics = (ScanMetrics)mri.updateIndex((Index)index, SchemaAction.DISCARD_INDEX).get();
        Assertions.assertEquals((long)12L, (long)metrics.getCustom("deletes"));
    }

    @Test
    public void testRemoveGraphIndexWithToolRunner() throws Exception {
        this.prepareGraphIndex();
        MapReduceRemoveIndexApp app = new MapReduceRemoveIndexApp((JanusGraph)this.graph, "name");
        Assertions.assertThrows(FileNotFoundException.class, () -> ToolRunner.run((Tool)app, (String[])new String[]{"-files", "invalid-file.txt"}));
        ToolRunner.run((Tool)app, (String[])new String[]{"-files", ((Object)((Object)this)).getClass().getClassLoader().getResource("log4j2-test.xml").getPath()});
        Assertions.assertEquals((long)12L, (long)app.getMetrics().getCustom("deletes"));
    }

    @Test
    public void testRemoveRelationIndex() throws InterruptedException, BackendException, ExecutionException {
        this.tx.commit();
        this.mgmt.commit();
        GraphOfTheGodsFactory.loadWithoutMixedIndex((JanusGraph)this.graph, (boolean)true);
        JanusGraphManagement m = this.graph.openManagement();
        RelationType battled = m.getRelationType("battled");
        RelationTypeIndex battlesByTime = m.getRelationIndex(battled, "battlesByTime");
        m.updateIndex((Index)battlesByTime, SchemaAction.DISABLE_INDEX);
        m.commit();
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((JanusGraph)this.graph, (String)"battlesByTime", (String)"battled").status(new SchemaStatus[]{SchemaStatus.DISABLED})).call().getSucceeded());
        MapReduceIndexManagement mri = new MapReduceIndexManagement((JanusGraph)this.graph);
        m = this.graph.openManagement();
        battled = m.getRelationType("battled");
        battlesByTime = m.getRelationIndex(battled, "battlesByTime");
        ScanMetrics metrics = (ScanMetrics)mri.updateIndex((Index)battlesByTime, SchemaAction.DISCARD_INDEX).get();
        Assertions.assertEquals((long)6L, (long)metrics.getCustom("deletes"));
    }

    @Test
    public void testRepairGraphIndex() throws InterruptedException, BackendException, ExecutionException {
        this.tx.commit();
        this.mgmt.commit();
        GraphOfTheGodsFactory.loadWithoutMixedIndex((JanusGraph)this.graph, (boolean)true);
        JanusGraphManagement m = this.graph.openManagement();
        PropertyKey age = m.getPropertyKey("age");
        m.buildIndex("verticesByAge", Vertex.class).addKey(age).buildCompositeIndex();
        m.commit();
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"verticesByAge").status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call().getSucceeded());
        m = this.graph.openManagement();
        JanusGraphIndex index = m.getGraphIndex("verticesByAge");
        m.updateIndex((Index)index, SchemaAction.ENABLE_INDEX);
        m.commit();
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"verticesByAge").status(new SchemaStatus[]{SchemaStatus.ENABLED})).call().getSucceeded());
        Assertions.assertFalse((boolean)this.graph.query().has("age", (Object)10000).vertices().iterator().hasNext());
        MapReduceIndexManagement mri = new MapReduceIndexManagement((JanusGraph)this.graph);
        m = this.graph.openManagement();
        index = m.getGraphIndex("verticesByAge");
        ScanMetrics metrics = (ScanMetrics)mri.updateIndex((Index)index, SchemaAction.REINDEX).get();
        Assertions.assertEquals((long)6L, (long)metrics.getCustom("adds"));
        Iterable hits = this.graph.query().has("age", (Object)4500).vertices();
        Assertions.assertNotNull((Object)hits);
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)hits));
        JanusGraphVertex v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)hits);
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((Object)"neptune", (Object)v.value("name"));
    }

    @Test
    public void testRepairRelationIndex() throws InterruptedException, BackendException, ExecutionException {
        this.tx.commit();
        this.mgmt.commit();
        GraphOfTheGodsFactory.loadWithoutMixedIndex((JanusGraph)this.graph, (boolean)true);
        JanusGraphManagement m = this.graph.openManagement();
        PropertyKey reason = m.getPropertyKey("reason");
        EdgeLabel lives = m.getEdgeLabel("lives");
        m.buildEdgeIndex(lives, "livesByReason", Direction.BOTH, Order.desc, new PropertyKey[]{reason});
        m.commit();
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((JanusGraph)this.graph, (String)"livesByReason", (String)"lives").status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call().getSucceeded());
        m = this.graph.openManagement();
        RelationTypeIndex index = m.getRelationIndex(m.getRelationType("lives"), "livesByReason");
        m.updateIndex((Index)index, SchemaAction.ENABLE_INDEX);
        m.commit();
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((JanusGraph)this.graph, (String)"livesByReason", (String)"lives").status(new SchemaStatus[]{SchemaStatus.ENABLED})).call().getSucceeded());
        MapReduceIndexManagement mri = new MapReduceIndexManagement((JanusGraph)this.graph);
        m = this.graph.openManagement();
        index = m.getRelationIndex(m.getRelationType("lives"), "livesByReason");
        ScanMetrics metrics = (ScanMetrics)mri.updateIndex((Index)index, SchemaAction.REINDEX).get();
        Assertions.assertEquals((long)8L, (long)metrics.getCustom("adds"));
    }
}

